/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.items;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.mint_gaming_studios.recased.events.ItemManager;

public class CustomItem
extends Item {
    private final String name;
    private final String rarity;
    private final String itemType;
    private final int attackDamage;
    private final int durability;

    public CustomItem(String name, int attackDamage, int durability, Item.Properties properties) {
        super(properties);
        this.name = name;
        this.attackDamage = attackDamage;
        this.durability = durability;
        this.itemType = this.determineItemType();
        this.rarity = this.determineRarity();
        if (this.itemType != null) {
            ItemManager.addCustomType(new ItemStack((ItemLike)this), this.itemType);
        }
    }

    public CustomItem(String name, Item.Properties properties) {
        this(name, 0, 0, properties);
    }

    private String determineItemType() {
        ItemStack stack = new ItemStack((ItemLike)this);
        return ItemManager.determineItemType(stack);
    }

    private String determineRarity() {
        return "Common";
    }

    public int getAttackDamage() {
        return this.attackDamage;
    }

    public int getDurability() {
        return this.durability;
    }

    public String getName() {
        return this.name;
    }

    public String getRarity() {
        return this.rarity;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String toString() {
        return String.format("%s - Type: %s, Rarity: %s, Damage: %d, Durability: %d", this.name, this.itemType, this.rarity, this.attackDamage, this.durability);
    }
}

