/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.items;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.mint_gaming_studios.recased.items.CustomItem;

public class ItemRanker {
    private static final List<String> excludedItems = new ArrayList<String>();

    public static void main(String[] args) {
        String config = "{ \"excludedItems\": [\"Modded Trash Sword\", \"Debug Item\"] }";
        ItemRanker.loadConfig(config);
        List<CustomItem> items = Arrays.asList(new CustomItem("Netherite Sword", 12, 2031, new Item.Properties()), new CustomItem("Diamond Sword", 7, 1561, new Item.Properties()), new CustomItem("Wooden Sword", 4, 59, new Item.Properties()));
        ItemRanker.prepareAndSortItems(items);
        System.out.println("Sorted Items:");
        items.forEach(System.out::println);
    }

    private static void loadConfig(String configContent) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, List<String>>>(){}.getType();
        Map configMap = (Map)gson.fromJson(configContent, mapType);
        if (configMap != null && configMap.containsKey("excludedItems")) {
            excludedItems.addAll((Collection)configMap.get("excludedItems"));
        }
    }

    private static void prepareAndSortItems(List<CustomItem> items) {
        items.sort(Comparator.comparing(CustomItem::getRarity, Comparator.nullsLast(Comparator.naturalOrder())));
    }
}

