/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.recased.block.ModBlocks;
import net.mint_gaming_studios.recased.client.ClientEventHandler;
import net.mint_gaming_studios.recased.commands.ListItemsByTypeCommand;
import net.mint_gaming_studios.recased.events.ItemManager;
import net.mint_gaming_studios.recased.events.ItemTooltipHandler;
import net.mint_gaming_studios.recased.helper.DynamicItemRegistry;
import net.mint_gaming_studios.recased.items.ModCreativeModeTabs;
import net.mint_gaming_studios.recased.items.ModItems;
import net.mint_gaming_studios.recased.loot.ModLootModifiers;
import net.mint_gaming_studios.recased.menu.ModMenuTypes;
import net.mint_gaming_studios.recased.villager.ModVillagers;
import org.slf4j.Logger;

@Mod(value="recased")
public class ReCased {
    public static final String MOD_ID = "recased";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ReCased() {
        block3: {
            try {
                IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
                ModItems.register(modEventBus);
                ModMenuTypes.MENUS.register(modEventBus);
                ModCreativeModeTabs.register(modEventBus);
                ModVillagers.register(modEventBus);
                ModBlocks.register(modEventBus);
                ModLootModifiers.register(modEventBus);
                MinecraftForge.EVENT_BUS.register((Object)new ItemTooltipHandler());
                modEventBus.addListener(this::onCommonSetup);
                modEventBus.addListener(this::onLoadComplete);
                MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
                MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    ClientEventHandler.registerScreens(modEventBus);
                }
            }
            catch (Exception e) {
                if (this.isModSpecific(e)) break block3;
                throw e;
            }
        }
    }

    private boolean isModSpecific(Exception e) {
        if (e instanceof NullPointerException) {
            for (StackTraceElement element : e.getStackTrace()) {
                if (!element.getClassName().contains("net.minecraft.world.inventory.AbstractContainerMenu")) continue;
                return true;
            }
        }
        return false;
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Starte das Common-Setup f\u00fcr {}.", (Object)MOD_ID);
        this.initializeDynamicItems();
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("Alle Mods wurden erfolgreich geladen. Starte die vollst\u00e4ndige Initialisierung aller Items...");
        this.initializeDynamicItems();
    }

    private void initializeDynamicItems() {
        LOGGER.info("Starte die vollst\u00e4ndige Registrierung aller registrierten Items in DynamicItemRegistry...");
        ArrayList<Item> unregisteredItems = new ArrayList<Item>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (item == null) continue;
            String type = this.determineType(item);
            String rarity = this.determineRarity(item);
            DynamicItemRegistry.registerItemType(item, type);
            DynamicItemRegistry.registerItemRarity(item, rarity);
            ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
            if (DynamicItemRegistry.getTypeForItem(item).isEmpty() || DynamicItemRegistry.getRarityForItem(item).isEmpty()) {
                unregisteredItems.add(item);
                LOGGER.warn("Fehlgeschlagene Registrierung f\u00fcr Item: {}", (Object)itemRegistryName);
                continue;
            }
            if (itemRegistryName != null) {
                LOGGER.debug("Erfolgreich registriert: {} | Typ: {} | Rarit\u00e4t: {}", new Object[]{itemRegistryName, type, rarity});
                continue;
            }
            LOGGER.warn("Item hat keinen g\u00fcltigen Registrierungsschl\u00fcssel: {}", (Object)item);
        }
        if (!unregisteredItems.isEmpty()) {
            LOGGER.warn("Folgende Items konnten nicht korrekt registriert werden: {}", unregisteredItems);
        } else {
            LOGGER.info("Alle Items wurden erfolgreich registriert.");
        }
    }

    private String determineType(Item item) {
        return "default_type";
    }

    private String determineRarity(Item item) {
        return "common";
    }

    private void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Starte Server-Initialisierung f\u00fcr {}...", (Object)MOD_ID);
        ItemManager.initializeItemTypes();
        LOGGER.info("Server-Initialisierung abgeschlossen!");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"listitems").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            if (player != null) {
                ItemManager.outputItemsByTypeToChat(player);
            }
            return 1;
        }));
        LOGGER.info("/listitems-Befehl erfolgreich registriert!");
    }

    @Mod.EventBusSubscriber(modid="recased", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CommandRegistration {
        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            ListItemsByTypeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }
}

