/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.recased.helper.DynamicItemRegistry;
import net.mint_gaming_studios.recased.items.LootCaseItem;

public class LootCaseMenu
extends AbstractContainerMenu {
    private final DynamicContainer container;
    private final String lootCaseType;
    public final Container centerContainer = new SimpleContainer(9);
    private boolean centerSlotsVisible = false;
    private boolean isRewardGiven = false;
    private static final List<String> RARITY_ORDER = Arrays.asList("common", "rare", "epic", "legendary");
    public static final int VISIBLE_ROWS = 4;
    public static final int COLUMNS_PER_ROW = 9;
    public static final int SLOT_SIZE = 18;
    public int scrollOffset = 0;
    public final Player player;
    private final RandomSource random = RandomSource.m_216327_();
    private int slotStartX = 8;
    private int slotStartY = 18;
    private static final int MINIMUM_SLOTS = 200;

    public LootCaseMenu(MenuType<?> type, int id, SimpleContainer playerInventory, String lootCaseType, Player player) {
        super(type, id);
        this.lootCaseType = lootCaseType;
        this.player = player;
        int initialSize = Math.max(Math.max(DynamicItemRegistry.getItemsByType(lootCaseType).size(), playerInventory.m_6643_()), "potion".equals(lootCaseType) || "enchantment".equals(lootCaseType) || "arrow".equals(lootCaseType) ? 200 : 0);
        this.container = new DynamicContainer(250000);
        this.adjustContainerSizeAndPopulate();
        this.removeEmptySlots();
        this.createScrollSlots();
    }

    private void removeEmptySlots() {
        List nonEmptyItems = this.container.items.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
        int newSize = nonEmptyItems.size();
        NonNullList resizedItems = NonNullList.m_122780_((int)newSize, (Object)ItemStack.f_41583_);
        for (int i = 0; i < newSize; ++i) {
            resizedItems.set(i, (Object)((ItemStack)nonEmptyItems.get(i)));
        }
        this.m_38946_();
        this.container.items = resizedItems;
        this.createScrollSlots();
    }

    public String getLootCaseType() {
        return this.lootCaseType;
    }

    public void fillCenterSlotsRandomly() {
        for (int i = 0; i < this.centerContainer.m_6643_(); ++i) {
            ItemStack randomStack = this.getRandomItem();
            this.centerContainer.m_6836_(i, randomStack);
            System.out.println("Center Slot Item: " + randomStack.m_41720_() + ", Menge: " + randomStack.m_41613_() + ", Durability: " + randomStack.m_41773_());
        }
    }

    public void scrollCenterSlots() {
        for (int i = 0; i < this.centerContainer.m_6643_() - 1; ++i) {
            this.centerContainer.m_6836_(i, this.centerContainer.m_8020_(i + 1));
        }
        this.centerContainer.m_6836_(this.centerContainer.m_6643_() - 1, this.getRandomItem());
    }

    public void selectFinalReward() {
        ItemStack rewardStack = this.centerContainer.m_8020_(4).m_41777_();
        System.out.println("Attempting to process reward item...");
        System.out.println("Selected reward item: Name=" + rewardStack.m_41786_().getString() + " Count=" + rewardStack.m_41613_());
        if (!rewardStack.m_41619_()) {
            block23: {
                boolean addedToInventory = this.addToMainInventory(this.player, rewardStack);
                System.out.println("Remaining reward stack after inventory attempt: Count=" + rewardStack.m_41613_());
                if (!addedToInventory) {
                    System.out.println("Player inventory is full; attempting to drop item at player's position.");
                    Level world = this.player.m_9236_();
                    if (world != null) {
                        System.out.println("World is valid. Preparing to drop item...");
                        try {
                            if (!rewardStack.m_41619_()) {
                                boolean entityAdded;
                                System.out.println("Reward Stack is valid, proceeding to drop logic.");
                                ItemEntity itemEntity = new ItemEntity(world, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), rewardStack);
                                itemEntity.m_20334_(0.0, 0.1, 0.0);
                                System.out.println("Created ItemEntity: Type=" + rewardStack.m_41720_().getClass().getName() + ", Count=" + rewardStack.m_41613_() + ", At Position=" + this.player.m_20185_() + ", " + this.player.m_20186_() + ", " + this.player.m_20189_());
                                BlockPos playerPos = BlockPos.m_274561_((double)this.player.m_20185_(), (double)this.player.m_20186_(), (double)this.player.m_20189_());
                                if (!world.m_46805_(playerPos)) {
                                    System.err.println("Chunk at player's position is not loaded! Attempting fallback...");
                                    BlockPos fallbackPos = world.m_220360_();
                                    itemEntity.m_6034_((double)fallbackPos.m_123341_(), (double)fallbackPos.m_123342_(), (double)fallbackPos.m_123343_());
                                    System.out.println("Fallback Position: " + fallbackPos);
                                }
                                if (entityAdded = world.m_7967_((Entity)itemEntity)) {
                                    System.out.println("Item successfully dropped: " + rewardStack.m_41786_().getString());
                                } else {
                                    System.err.println("Failed to add ItemEntity to the world. Something interrupted the process.");
                                }
                                break block23;
                            }
                            System.err.println("Reward stack unexpectedly empty during drop logic.");
                        }
                        catch (Exception e) {
                            System.err.println("An error occurred while dropping the item!");
                            e.printStackTrace();
                        }
                    } else {
                        System.err.println("World is null! Unable to process item drop.");
                    }
                } else {
                    System.out.println("Reward item successfully added to inventory.");
                }
            }
            this.isRewardGiven = true;
            String rarity = this.extractRewardItemRarityFromTooltip(rewardStack);
            System.out.println("Final reward rarity determined: " + rarity);
            switch (rarity.toLowerCase()) {
                case "legendary": {
                    this.player.m_9236_().m_5594_(this.player, BlockPos.m_274446_((Position)this.player.m_20182_()), SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case "epic": {
                    this.player.m_9236_().m_5594_(this.player, BlockPos.m_274446_((Position)this.player.m_20182_()), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case "rare": {
                    this.player.m_9236_().m_5594_(this.player, BlockPos.m_274446_((Position)this.player.m_20182_()), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.6f, 1.0f);
                    break;
                }
                default: {
                    this.player.m_9236_().m_5594_(this.player, BlockPos.m_274446_((Position)this.player.m_20182_()), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    break;
                }
            }
        } else {
            System.out.println("Reward stack is empty! No reward given.");
        }
    }

    private boolean addToMainInventory(Player player, ItemStack rewardStack) {
        Inventory inventory = player.m_150109_();
        System.out.println("Attempting to add item to inventory: Name=" + rewardStack.m_41786_().getString() + " Count=" + rewardStack.m_41613_());
        for (int i = 0; i < 36; ++i) {
            ItemStack currentStack = inventory.m_8020_(i);
            if (currentStack.m_41619_()) {
                inventory.m_6836_(i, rewardStack);
                System.out.println("Item was placed into inventory at slot " + i);
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)rewardStack) || currentStack.m_41613_() >= currentStack.m_41741_()) continue;
            int transferAmount = Math.min(rewardStack.m_41613_(), currentStack.m_41741_() - currentStack.m_41613_());
            System.out.println("Stackable slot found at " + i + " with space for " + transferAmount + " items.");
            currentStack.m_41769_(transferAmount);
            rewardStack.m_41774_(transferAmount);
            if (!rewardStack.m_41619_()) continue;
            System.out.println("Entire reward stack successfully placed into inventory.");
            return true;
        }
        System.out.println("No available inventory slot to add the item.");
        return false;
    }

    public void onCloseMenu() {
        if (!this.isRewardGiven) {
            return;
        }
        for (int i = 0; i < this.player.m_150109_().m_6643_(); ++i) {
            LootCaseItem lootCaseItem;
            ItemStack stack = this.player.m_150109_().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof LootCaseItem) || !(lootCaseItem = (LootCaseItem)item).getType().equals(this.lootCaseType)) continue;
            if (stack.m_41613_() > 1) {
                stack.m_41774_(1);
            } else {
                this.player.m_150109_().m_7407_(i, 1);
            }
            return;
        }
    }

    private ItemStack getRandomItem() {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_()) continue;
            allItems.add(stack);
        }
        if (allItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ArrayList<ItemStack> commonItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> rareItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> epicItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> legendaryItems = new ArrayList<ItemStack>();
        block11: for (ItemStack item : allItems) {
            String rarity;
            switch (rarity = this.extractItemRarityFromTooltip(item)) {
                case "legendary": {
                    legendaryItems.add(item);
                    continue block11;
                }
                case "epic": {
                    epicItems.add(item);
                    continue block11;
                }
                case "rare": {
                    rareItems.add(item);
                    continue block11;
                }
            }
            commonItems.add(item);
        }
        if (commonItems.isEmpty() && rareItems.isEmpty() && epicItems.isEmpty() && legendaryItems.isEmpty()) {
            return (ItemStack)allItems.get(this.random.m_188503_(allItems.size()));
        }
        int randomValue = this.random.m_188503_(100);
        if (randomValue < 60 && !commonItems.isEmpty()) {
            return this.getRandomFromList(commonItems);
        }
        if (randomValue < 85 && !rareItems.isEmpty()) {
            return this.getRandomFromList(rareItems);
        }
        if (randomValue < 95 && !epicItems.isEmpty()) {
            return this.getRandomFromList(epicItems);
        }
        if (!legendaryItems.isEmpty()) {
            return this.getRandomFromList(legendaryItems);
        }
        return ItemStack.f_41583_;
    }

    private ItemStack getRandomFromList(List<ItemStack> items) {
        if (items.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ArrayList<ItemStack> safeItems = new ArrayList<ItemStack>(items);
        if (safeItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = (ItemStack)safeItems.get(this.random.m_188503_(safeItems.size()));
        Random random = new Random();
        ItemStack stack_random = items.get(random.nextInt(items.size()));
        if (stack_random.m_41763_()) {
            int maxDurability = stack_random.m_41776_();
            if (maxDurability <= 15) {
                stack_random.m_41721_(0);
            } else {
                int randomDurability = random.nextInt(maxDurability - 15) + 15;
                stack_random.m_41721_(maxDurability - randomDurability);
            }
        }
        return stack_random;
    }

    public ItemStack getCenterSlotStack(int index) {
        this.m_38946_();
        if (index < 0 || index >= this.centerContainer.m_6643_()) {
            return ItemStack.f_41583_;
        }
        return this.centerContainer.m_8020_(index);
    }

    public boolean isScrollSlot(int index) {
        int visibleSlots = 36;
        return index >= this.container.m_6643_() - visibleSlots;
    }

    private void adjustContainerSizeAndPopulate() {
        List<ResourceLocation> items = DynamicItemRegistry.getItemsByType(this.lootCaseType);
        this.m_38946_();
        int requiredSize = Math.max(items.size(), 200);
        if ("potion".equals(this.lootCaseType) || "enchantment".equals(this.lootCaseType) || "arrow".equals(this.lootCaseType)) {
            requiredSize = Math.max(requiredSize, 200);
        }
        if (this.container.m_6643_() < requiredSize) {
            this.container.resize(requiredSize);
        }
        this.m_38946_();
        this.populateLootItems(this.lootCaseType);
        this.m_38946_();
    }

    public ItemStack getRandomItemByRarity(String rarity) {
        List matchingItems = this.f_38839_.stream().map(Slot::m_7993_).filter(stack -> !stack.m_41619_() && this.extractItemRarityFromTooltip((ItemStack)stack).equals(rarity)).collect(Collectors.toList());
        if (matchingItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)matchingItems.get(this.random.m_188503_(matchingItems.size()));
    }

    private void populatePotions(List<ItemStack> itemStacks) {
        ForgeRegistries.POTIONS.getValues().forEach(potion -> {
            if (potion == Potions.f_43598_) {
                return;
            }
            ResourceLocation potionId = ForgeRegistries.POTIONS.getKey(potion);
            if (potionId != null && potionId.toString().toLowerCase().contains("uncraftable")) {
                return;
            }
            ItemStack normalPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
            itemStacks.add(normalPotion);
            ItemStack splashPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion);
            itemStacks.add(splashPotion);
            ItemStack lingeringPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion);
            itemStacks.add(lingeringPotion);
        });
    }

    private void populateEnchantedBooks(List<ItemStack> itemStacks) {
        ForgeRegistries.ENCHANTMENTS.getValues().forEach(enchantment -> {
            for (int level = 1; level <= enchantment.m_6586_(); ++level) {
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
                itemStacks.add(book);
            }
        });
    }

    private void populateTippedArrows(List<ItemStack> itemStacks) {
        ForgeRegistries.POTIONS.getValues().forEach(potion -> {
            ItemStack arrowStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)potion);
            arrowStack.m_41764_(this.random.m_188503_(64) + 16);
            itemStacks.add(arrowStack);
        });
    }

    private void populateFoodItems(List<ItemStack> itemStacks) {
        List<ResourceLocation> foodItems = DynamicItemRegistry.getItemsByType("food");
        for (ResourceLocation itemId : foodItems) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) continue;
            itemStacks.add(new ItemStack((ItemLike)item));
        }
    }

    private void populateLootItems(String type) {
        this.container.m_6211_();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        switch (type) {
            case "potion": {
                this.populatePotions(itemStacks);
                this.addGeneralItemsToCrate(type, itemStacks);
                break;
            }
            case "enchantment": {
                this.populateEnchantedBooks(itemStacks);
                this.addGeneralItemsToCrate(type, itemStacks);
                break;
            }
            case "arrow": {
                this.populateTippedArrows(itemStacks);
                this.addGeneralItemsToCrate(type, itemStacks);
                break;
            }
            case "food": {
                this.populateFoodItems(itemStacks);
                break;
            }
            default: {
                this.populateGeneralItems(type, itemStacks);
            }
        }
        itemStacks.removeIf(stack -> stack.m_41786_().getString().toLowerCase().contains("uncraftable"));
        itemStacks.forEach(item -> this.adjustQuantitiesByRarityForSpecificTypes((ItemStack)item, type));
        itemStacks.sort(this::compareByRarity);
        for (int i = 0; i < Math.min(itemStacks.size(), this.container.m_6643_()); ++i) {
            this.container.m_6836_(i, (ItemStack)itemStacks.get(i));
        }
        this.m_38946_();
    }

    private void filterExcludedItems(List<ItemStack> itemStacks, List<String> excludedItems) {
        if (excludedItems == null || excludedItems.isEmpty()) {
            return;
        }
        itemStacks.removeIf(itemStack -> {
            boolean isExcluded = excludedItems.contains(itemStack.m_41720_().toString());
            if (isExcluded) {
                // empty if block
            }
            return isExcluded;
        });
    }

    private void populateGeneralItems(String type, List<ItemStack> itemStacks) {
        List<ResourceLocation> items = DynamicItemRegistry.getItemsByType(type);
        for (ResourceLocation itemId : items) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) continue;
            itemStacks.add(new ItemStack((ItemLike)item));
        }
    }

    private void addGeneralItemsToCrate(String type, List<ItemStack> itemStacks) {
        List<ResourceLocation> generalItems = DynamicItemRegistry.getItemsByType(type);
        for (ResourceLocation itemId : generalItems) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) continue;
            itemStacks.add(new ItemStack((ItemLike)item));
        }
    }

    private void debugPrintPotions(List<ItemStack> itemStacks) {
        for (ItemStack stack : itemStacks) {
            if (stack.m_41720_() != Items.f_42589_ && stack.m_41720_() != Items.f_42736_ && stack.m_41720_() != Items.f_42739_) continue;
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        }
    }

    private int compareByRarity(ItemStack stack1, ItemStack stack2) {
        String rarity1 = this.extractItemRarityFromTooltip(stack1);
        String rarity2 = this.extractItemRarityFromTooltip(stack2);
        return Integer.compare(this.getRarityValue(rarity1), this.getRarityValue(rarity2));
    }

    public String extractItemRarityFromTooltip(ItemStack stack) {
        List tooltip = stack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_);
        for (Component line : tooltip) {
            String lineText = line.getString().toLowerCase();
            if (!lineText.contains("rarity:")) continue;
            String rarity = lineText.replace("rarity:", "").trim();
            return rarity;
        }
        return "common";
    }

    public String extractRewardItemRarityFromTooltip(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return "common";
        }
        List tooltipLines = stack.m_41651_(this.player, (TooltipFlag)TooltipFlag.Default.f_256752_);
        for (Component component : tooltipLines) {
        }
        for (Component line : tooltipLines) {
            String text = line.getString();
            if (!text.startsWith("Rarity: ")) continue;
            String rarity = text.substring(8).trim().toLowerCase();
            return rarity;
        }
        return "common";
    }

    private int getRarityValue(String rarity) {
        return switch (rarity) {
            case "rare" -> 1;
            case "epic" -> 2;
            case "legendary" -> 3;
            default -> 0;
        };
    }

    public void setCenterSlotsVisible(boolean visible) {
        if (this.centerSlotsVisible == visible) {
            return;
        }
        this.centerSlotsVisible = visible;
        if (visible) {
            int centerSlotStartX = this.slotStartX + 0;
            int centerSlotStartY = this.slotStartY - 60;
            this.createCenterSlots(centerSlotStartX, centerSlotStartY);
        } else {
            this.removeCenterSlots();
        }
    }

    public void createCenterSlots(int startX, int startY) {
        for (int i = 0; i < 9; ++i) {
            int x = startX + i * 18;
            int y = startY;
            this.m_38897_(new NonRemovableSlot(this.centerContainer, i, x, y){

                public ItemStack m_7993_() {
                    return super.m_7993_();
                }
            });
        }
    }

    private void removeCenterSlots() {
        this.f_38839_.removeIf(slot -> slot.f_40218_ == this.centerContainer);
    }

    public void setSlotStartPosition(int startX, int startY) {
        this.slotStartX = startX;
        this.slotStartY = startY;
        this.createScrollSlots();
    }

    private void createScrollSlots() {
        this.f_38839_.clear();
        int visibleSlots = 36;
        int totalRows = (int)Math.ceil((double)this.container.m_6643_() / 9.0);
        this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, totalRows - 4));
        int slotIndex = this.scrollOffset * 9;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9 && slotIndex < this.container.m_6643_(); ++col) {
                int x = this.slotStartX + col * 18;
                int y = this.slotStartY + row * 18;
                this.m_38897_(new NonRemovableSlot((Container)this.container, slotIndex++, x, y){

                    public ItemStack m_7993_() {
                        ItemStack actualStack = super.m_7993_();
                        if (!actualStack.m_41619_()) {
                            ItemStack displayStack = actualStack.m_41777_();
                            displayStack.m_41764_(1);
                            if (displayStack.m_41763_()) {
                                displayStack.m_41721_(0);
                            }
                            return displayStack;
                        }
                        return actualStack;
                    }
                });
            }
        }
    }

    public void scroll(int direction) {
        int totalRows = (int)Math.ceil((double)this.container.m_6643_() / 9.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset + direction, totalRows - 4));
        this.createScrollSlots();
    }

    private void adjustQuantitiesByRarityForSpecificTypes(ItemStack itemStack, String type) {
        String rarity;
        if (!type.equals("arrow") && !type.equals("food")) {
            return;
        }
        switch (rarity = this.extractItemRarityFromTooltip(itemStack)) {
            case "common": {
                itemStack.m_41764_(this.random.m_188503_(64) + 16);
                break;
            }
            case "rare": {
                itemStack.m_41764_(this.random.m_188503_(32) + 8);
                break;
            }
            case "epic": {
                itemStack.m_41764_(this.random.m_188503_(16) + 4);
                break;
            }
            case "legendary": {
                itemStack.m_41764_(this.random.m_188503_(8) + 1);
                break;
            }
            default: {
                itemStack.m_41764_(1);
            }
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean isRewardGiven() {
        return this.isRewardGiven;
    }

    public Slot m_38853_(int index) {
        if (index >= 0 && index < this.f_38839_.size()) {
            return super.m_38853_(index);
        }
        return null;
    }

    public static class DynamicContainer
    extends SimpleContainer {
        private NonNullList<ItemStack> items;

        public DynamicContainer(int initialSize) {
            super(initialSize);
            this.items = NonNullList.m_122780_((int)initialSize, (Object)ItemStack.f_41583_);
        }

        public void resize(int newSize) {
            NonNullList newItems = NonNullList.m_122780_((int)newSize, (Object)ItemStack.f_41583_);
            for (int i = 0; i < Math.min(this.items.size(), newItems.size()); ++i) {
                newItems.set(i, (Object)((ItemStack)this.items.get(i)));
            }
            this.items = newItems;
        }

        public int m_6643_() {
            return this.items.size();
        }

        public ItemStack m_8020_(int index) {
            if (index >= 0 && index < this.items.size()) {
                return (ItemStack)this.items.get(index);
            }
            return ItemStack.f_41583_;
        }

        public void m_6836_(int index, ItemStack stack) {
            if (index >= 0 && index < this.items.size()) {
                this.items.set(index, (Object)stack);
            }
        }

        public void m_6211_() {
            this.items.clear();
        }
    }

    private static class NonRemovableSlot
    extends Slot {
        public NonRemovableSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_8010_(Player player) {
            return false;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }
}

