/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.menu;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.mint_gaming_studios.recased.helper.DynamicItemRegistry;
import net.mint_gaming_studios.recased.menu.LootCaseMenu;
import net.mint_gaming_studios.recased.menu.ModMenuTypes;

public class LootCaseMenuProvider
implements MenuProvider {
    private static final Map<String, Integer> LOOTCASE_SIZES = new HashMap<String, Integer>();
    private final String lootCaseType;
    private final int containerSize;

    public LootCaseMenuProvider(String lootCaseType) {
        this.lootCaseType = lootCaseType.toLowerCase();
        this.containerSize = LOOTCASE_SIZES.getOrDefault(this.lootCaseType, LOOTCASE_SIZES.get("default"));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)("menu.recased.loot_case." + this.lootCaseType));
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        String lootCaseType = this.getLootCaseType();
        int initialSize = Math.max(DynamicItemRegistry.getItemsByType(lootCaseType).size(), playerInventory.m_6643_());
        SimpleContainer dynamicContainer = new SimpleContainer(initialSize);
        return new LootCaseMenu((MenuType)ModMenuTypes.LOOT_CASE_MENU.get(), id, dynamicContainer, lootCaseType, player);
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.lootCaseType);
    }

    public static LootCaseMenuProvider fromBuffer(FriendlyByteBuf buf) {
        String lootCaseType = buf.m_130277_();
        return new LootCaseMenuProvider(lootCaseType);
    }

    public String getLootCaseType() {
        return this.lootCaseType;
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    static {
        LOOTCASE_SIZES.put("weapon", 36);
        LOOTCASE_SIZES.put("tool", 27);
        LOOTCASE_SIZES.put("armor", 45);
        LOOTCASE_SIZES.put("default", 27);
    }
}

