/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.mint_gaming_studios.recased.items.LootCaseItem;
import net.mint_gaming_studios.recased.menu.LootCaseMenu;

public class LootCaseScreen
extends AbstractContainerScreen<LootCaseMenu> {
    private static final ResourceLocation GUI_TEXTURE_NORMAL = new ResourceLocation("recased", "textures/gui/loot_case.png");
    private static final ResourceLocation GUI_TEXTURE_SPINNING = new ResourceLocation("recased", "textures/gui/loot_case_spinning.png");
    private ResourceLocation currentGuiTexture = GUI_TEXTURE_NORMAL;
    private Button openCrateButton;
    private Button closeButton;
    private Component caseTitle;
    private final int RARE_COLOR = 0x55FF55;
    private final int EPIC_COLOR = 0xAA00AA;
    private final int LEGENDARY_COLOR = 16766720;
    private final int COMMON_COLOR = 0xAAAAAA;
    private boolean isSpinning = false;
    private int spinTicks = 0;
    private final int MAX_SPIN_TICKS = 500;
    private float currentSpeed = 0.0f;
    private final float MAX_SPEED = 25.0f;
    private final int SLOWDOWN_START = 200;
    private static long lastXylophoneSoundTime = 0L;
    private static final long COOLDOWN_TIME_MS = 40L;
    public static int CASES_OPENED_AMOUNT = 0;

    public LootCaseScreen(LootCaseMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        Player player = inventory.f_35978_;
        ItemStack caseItem = this.findCaseItemInHand(player);
        this.caseTitle = !caseItem.m_41619_() ? caseItem.m_41786_() : Component.m_237113_((String)"Unknown Case");
        this.f_97727_ = 200;
        this.f_97726_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> this.m_7379_()).m_252987_(this.f_97735_ + 3, this.f_97736_ + 3, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.openCrateButton = Button.m_253074_((Component)Component.m_237113_((String)"Open Case"), button -> {
            System.out.println("Loot Case ge\u00f6ffnet!");
            if (!this.isSpinning && !((LootCaseMenu)this.f_97732_).isRewardGiven()) {
                this.isSpinning = true;
                this.spinTicks = 0;
                this.currentSpeed = 2.0f;
                ((LootCaseMenu)this.f_97732_).fillCenterSlotsRandomly();
                this.currentGuiTexture = GUI_TEXTURE_SPINNING;
            }
        }).m_252987_(this.f_97735_ + this.f_97726_ / 2 - 40, this.f_97736_ + 62, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.openCrateButton);
        int slotStartX = this.f_97735_ + this.f_97726_ / 2 - 81 - 152;
        int slotStartY = this.f_97736_ + 100 - 40;
        ((LootCaseMenu)this.f_97732_).setSlotStartPosition(slotStartX, slotStartY);
    }

    private ItemStack findCaseItemInHand(Player player) {
        ItemStack itemInHand = player.m_21205_();
        if (itemInHand.m_41720_() instanceof LootCaseItem) {
            return itemInHand;
        }
        return ItemStack.f_41583_;
    }

    private ItemStack neutralizeStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return stack;
        }
        ItemStack displayStack = stack.m_41777_();
        displayStack.m_41764_(1);
        if (displayStack.m_41763_()) {
            displayStack.m_41721_(0);
        }
        return displayStack;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(this.currentGuiTexture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.isSpinning) {
            ++this.spinTicks;
            this.currentSpeed = this.spinTicks < 200 ? Math.min(25.0f, this.currentSpeed + 0.5f) : Math.max(1.0f, this.currentSpeed - 0.5f);
            if (this.spinTicks % (int)(30.0f / this.currentSpeed) == 0) {
                ((LootCaseMenu)this.f_97732_).scrollCenterSlots();
                this.playXylophoneSound();
            }
            if (this.spinTicks >= 500) {
                this.isSpinning = false;
                this.currentSpeed = 0.0f;
                ((LootCaseMenu)this.f_97732_).selectFinalReward();
            }
        }
        for (int i = 0; i < 9; ++i) {
            int slotX = this.f_97735_ + this.f_97726_ / 2 - 72 + i * 18 - 10;
            int slotY = this.f_97736_ + 40 - 5;
            ItemStack stack = ((LootCaseMenu)this.f_97732_).getCenterSlotStack(i);
            if (!stack.m_41619_()) {
                String rarity;
                int color = switch (rarity = ((LootCaseMenu)this.f_97732_).extractItemRarityFromTooltip(stack)) {
                    case "rare" -> 0x55FF55;
                    case "epic" -> 0xAA00AA;
                    case "legendary" -> 16766720;
                    default -> 0xAAAAAA;
                };
                int bgX = slotX - 1;
                int bgY = slotY - 1;
                guiGraphics.m_280509_(bgX, bgY, bgX + 18, bgY + 18, color | 0xFF000000);
            }
            guiGraphics.m_280480_(stack, slotX, slotY);
            this.renderStackDetails(guiGraphics, stack, slotX, slotY);
        }
        for (Slot slot : ((LootCaseMenu)this.f_97732_).f_38839_) {
            String rarity;
            if (!slot.m_6657_()) continue;
            ItemStack stack = slot.m_7993_();
            if (((LootCaseMenu)this.f_97732_).isScrollSlot(slot.f_40219_)) {
                stack = this.neutralizeStack(stack);
            }
            int color = switch (rarity = ((LootCaseMenu)this.f_97732_).extractItemRarityFromTooltip(stack)) {
                case "rare" -> 0x55FF55;
                case "epic" -> 0xAA00AA;
                case "legendary" -> 16766720;
                default -> 0xAAAAAA;
            };
            int x = this.f_97735_ + slot.f_40220_ - 1;
            int y = this.f_97736_ + slot.f_40221_ - 1;
            guiGraphics.m_280509_(x, y, x + 18, y + 18, color | 0xFF000000);
            guiGraphics.m_280480_(stack, x + 1, y + 1);
            this.renderStackDetails(guiGraphics, stack, x + 1, y + 1);
        }
    }

    private void renderStackDetails(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41613_() > 1) {
            String countText = String.valueOf(stack.m_41613_());
            int countX = x + 16 - this.f_96547_.m_92895_(countText);
            int countY = y + 12;
            guiGraphics.m_280488_(this.f_96547_, countText, countX, countY, 0xFFFFFF);
        }
        if (stack.m_41763_() && stack.m_41783_() != null) {
            int damage = stack.m_41783_().m_128451_("Damage");
            int maxDurability = stack.m_41776_();
            int durability = maxDurability - damage;
            float durabilityPercentage = (float)durability / (float)maxDurability;
            int barWidth = Math.round(durabilityPercentage * 13.0f);
            int barColor = this.getDurabilityColor(durabilityPercentage);
            guiGraphics.m_280509_(x + 2, y + 13, x + 2 + barWidth, y + 14, barColor);
        }
    }

    private int getDurabilityColor(float durabilityPercentage) {
        if ((double)durabilityPercentage > 0.5) {
            return 65280;
        }
        if ((double)durabilityPercentage > 0.25) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String title = this.caseTitle.getString();
        int titleX = (this.f_97726_ - this.f_96547_.m_92895_(title)) / 2;
        guiGraphics.m_280488_(this.f_96547_, title, titleX, 6, 0x404040);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            ((LootCaseMenu)this.f_97732_).scroll(1);
        } else if (delta > 0.0) {
            ((LootCaseMenu)this.f_97732_).scroll(-1);
        }
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (((LootCaseMenu)this.f_97732_).isRewardGiven()) {
            for (Renderable widget : this.f_169369_) {
                Button button;
                if (!(widget instanceof Button) || !(button = (Button)widget).m_6035_().getString().equals("Open Case")) continue;
                button.f_93623_ = false;
            }
        }
        this.renderTooltipForSlots(guiGraphics, mouseX, mouseY);
    }

    private void renderTooltipForSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (Slot slot : ((LootCaseMenu)this.f_97732_).f_38839_) {
            if (!this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY) || !slot.m_6657_()) continue;
            ItemStack stack = slot.m_7993_();
            guiGraphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
    }

    private void playXylophoneSound() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastXylophoneSoundTime >= 40L) {
            lastXylophoneSoundTime = currentTime;
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12218_.get(), 1.0f, 1.0f);
        }
    }

    private void playChestCloseSound() {
        Minecraft.m_91087_().f_91074_.m_9236_().m_5594_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_(), SoundEvents.f_11747_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_7379_() {
        Player player = ((LootCaseMenu)this.f_97732_).player;
        this.playChestCloseSound();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof LootCaseItem && ((LootCaseMenu)this.f_97732_).isRewardGiven()) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
        }
        this.currentGuiTexture = GUI_TEXTURE_NORMAL;
        ((LootCaseMenu)this.f_97732_).onCloseMenu();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

