/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.events;

import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.recased.config.ConfigHandler;
import net.mint_gaming_studios.recased.helper.DynamicItemRegistry;
import net.mint_gaming_studios.recased.tags.ModTags;

public class ItemTooltipHandler {
    public ItemTooltipHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        String itemType;
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (stack.m_41619_() || this.isExcluded(stack)) {
            return;
        }
        ConfigHandler.RarityDefinition rarityDefinition = this.checkSpecialItem(stack);
        if (rarityDefinition != null) {
            DynamicItemRegistry.registerItemRarity(item, rarityDefinition.getRarity());
            DynamicItemRegistry.registerItemType(item, rarityDefinition.getType());
            this.displayTooltipRarity(event, rarityDefinition.getRarity());
            this.displayTooltipType(event, rarityDefinition.getType());
            return;
        }
        String itemRarity = this.determineRarity(stack);
        if (itemRarity != null) {
            ChatFormatting rarityColor = ItemTooltipHandler.getColorForRarity(itemRarity);
            DynamicItemRegistry.registerItemRarity(item, itemRarity);
            if (event.getToolTip().stream().noneMatch(line -> line.getString().contains("Rarity:"))) {
                event.getToolTip().add(Component.m_237113_((String)"Rarity: ").m_7220_((Component)Component.m_237113_((String)itemRarity)).m_130940_(rarityColor));
            }
        }
        if ((itemType = this.determineType(stack)) != null) {
            DynamicItemRegistry.registerItemType(item, itemType);
            this.displayTooltipType(event, itemType);
        }
    }

    private void displayTooltipRarity(ItemTooltipEvent event, String itemRarity) {
        if (event.getToolTip().stream().noneMatch(line -> line.getString().contains("Rarity:"))) {
            event.getToolTip().add(Component.m_237113_((String)"Rarity: ").m_7220_((Component)Component.m_237113_((String)itemRarity)).m_130940_(ItemTooltipHandler.getColorForRarity(itemRarity)));
        }
    }

    private void displayTooltipType(ItemTooltipEvent event, String itemType) {
        if (event.getToolTip().stream().noneMatch(line -> line.getString().contains("Type:"))) {
            event.getToolTip().add(Component.m_237113_((String)"Type: ").m_7220_((Component)Component.m_237113_((String)itemType)).m_130940_(ChatFormatting.GRAY));
        }
    }

    private boolean isExcluded(ItemStack stack) {
        ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemKey == null) {
            return false;
        }
        return ConfigHandler.getExcludedItems().contains(itemKey.toString());
    }

    private ConfigHandler.RarityDefinition checkSpecialItem(ItemStack stack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return null;
        }
        return ConfigHandler.getSpecialItems().get(itemId.toString());
    }

    private String determineType(ItemStack stack) {
        Item item = stack.m_41720_();
        ConfigHandler.RarityDefinition rarityDefinition = this.checkSpecialItem(stack);
        if (rarityDefinition != null) {
            return rarityDefinition.getType();
        }
        if (item instanceof EnchantedBookItem) {
            return "enchantment";
        }
        if (item instanceof PotionItem) {
            return "potion";
        }
        if (item instanceof SwordItem || item instanceof TridentItem || stack.m_204117_(ModTags.ITEMS.WEAPONS)) {
            return "weapon";
        }
        if (item instanceof ArmorItem || stack.m_204117_(ModTags.ITEMS.ARMORS)) {
            return "armor";
        }
        if (item instanceof BowItem || item instanceof CrossbowItem || stack.m_204117_(ModTags.ITEMS.RANGED_WEAPONS)) {
            return "weapon";
        }
        if (item instanceof DiggerItem || item instanceof ShearsItem || stack.m_204117_(ModTags.ITEMS.TOOLS)) {
            return "tool";
        }
        if (item instanceof ArrowItem || stack.m_204117_(ModTags.ITEMS.ARROWS)) {
            return "arrow";
        }
        if (item.m_41472_() || stack.m_204117_(ModTags.ITEMS.FOOD)) {
            return "food";
        }
        return null;
    }

    private String determineRarity(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof PotionItem || item instanceof SplashPotionItem || item instanceof LingeringPotionItem) {
            return ItemTooltipHandler.calculatePotionRarity(stack);
        }
        if (stack.m_41720_().m_41472_()) {
            return ItemTooltipHandler.calculateFoodRarity(stack);
        }
        if (stack.m_41720_() instanceof SwordItem) {
            return ItemTooltipHandler.calculateSwordRarity(stack);
        }
        if (stack.m_41720_() instanceof DiggerItem) {
            return ItemTooltipHandler.calculateToolRarity(stack);
        }
        if (stack.m_41720_() instanceof ArmorItem) {
            return ItemTooltipHandler.calculateArmorRarity(stack);
        }
        if (stack.m_41720_() instanceof ArrowItem) {
            return ItemTooltipHandler.calculateArrowRarity(stack);
        }
        if (item instanceof EnchantedBookItem) {
            return ItemTooltipHandler.calculateEnchantmentRarity(stack);
        }
        return null;
    }

    public static String calculateArrowRarity(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof TippedArrowItem) {
            List effects = PotionUtils.m_43547_((ItemStack)stack);
            if (effects != null && !effects.isEmpty()) {
                int maxDuration = effects.stream().mapToInt(MobEffectInstance::m_19557_).max().orElse(0);
                if (maxDuration >= 1800) {
                    return "epic";
                }
                if (maxDuration >= 600) {
                    return "rare";
                }
            }
            return "common";
        }
        if (item instanceof SpectralArrowItem) {
            return "epic";
        }
        if (item instanceof ArrowItem) {
            int maxStackSize = stack.m_41741_();
            if (maxStackSize <= 16) {
                return "legendary";
            }
            if (maxStackSize <= 32) {
                return "epic";
            }
            return "common";
        }
        return "common";
    }

    public static String calculateEnchantmentRarity(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.isEmpty()) {
            return "common";
        }
        int maxTier = enchantments.values().stream().max(Integer::compareTo).orElse(1);
        if (maxTier == 1 && enchantments.size() == 1) {
            return "legendary";
        }
        if (maxTier == 1) {
            return "common";
        }
        if (maxTier == 2) {
            return "rare";
        }
        if (maxTier == 3) {
            return "epic";
        }
        return "legendary";
    }

    public static String calculatePotionRarity(ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        List effects = PotionUtils.m_43547_((ItemStack)stack);
        if (effects == null || effects.isEmpty()) {
            return "common";
        }
        int maxDuration = effects.stream().mapToInt(MobEffectInstance::m_19557_).max().orElse(0);
        boolean hasStrongEffect = effects.stream().anyMatch(effect -> effect.m_19564_() > 0);
        if (stack.m_41720_() instanceof LingeringPotionItem) {
            if (maxDuration >= 6000) {
                return "legendary";
            }
            if (maxDuration >= 3600) {
                return "epic";
            }
            if (maxDuration >= 1200) {
                return "rare";
            }
            return "common";
        }
        if (stack.m_41720_() instanceof SplashPotionItem) {
            if (maxDuration >= 4000 || hasStrongEffect) {
                return "legendary";
            }
            if (maxDuration >= 2400 || hasStrongEffect) {
                return "epic";
            }
            if (maxDuration >= 800) {
                return "rare";
            }
            return "common";
        }
        if (maxDuration >= 3600 || hasStrongEffect) {
            return "legendary";
        }
        if (maxDuration >= 1800) {
            return "epic";
        }
        if (maxDuration >= 600) {
            return "rare";
        }
        return "common";
    }

    public static String calculateArmorRarity(ItemStack stack) {
        String materialName;
        ArmorItem armor = (ArmorItem)stack.m_41720_();
        switch (materialName = armor.m_40401_().m_6082_()) {
            case "iron": {
                return "rare";
            }
            case "diamond": {
                return "epic";
            }
            case "netherite": {
                return "legendary";
            }
        }
        int defense = armor.m_40404_();
        int durability = stack.m_41776_();
        if (defense >= 3 && durability >= 407) {
            return "legendary";
        }
        if (defense >= 3 && durability >= 363) {
            return "epic";
        }
        if (defense >= 2 && durability >= 120) {
            return "rare";
        }
        return "common";
    }

    public static String calculateFoodRarity(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item.m_41472_()) {
            FoodProperties foodProps = item.m_41473_();
            int nutrition = foodProps != null ? foodProps.m_38744_() : 0;
            int maxStackSize = stack.m_41741_();
            if (nutrition >= 10 && maxStackSize <= 16) {
                return "legendary";
            }
            if (nutrition >= 7 && maxStackSize <= 32) {
                return "epic";
            }
            if (nutrition >= 4 && maxStackSize <= 64) {
                return "rare";
            }
        }
        return "common";
    }

    public static String calculateSwordRarity(ItemStack stack) {
        SwordItem sword = (SwordItem)stack.m_41720_();
        int attackDamage = (int)sword.m_43299_();
        int durability = stack.m_41776_();
        if (durability >= 2000 || attackDamage >= 12) {
            return "legendary";
        }
        if (durability >= 1500 || attackDamage >= 8) {
            return "epic";
        }
        if (durability >= 300 || attackDamage >= 5) {
            return "rare";
        }
        return "common";
    }

    public static String calculateToolRarity(ItemStack stack) {
        DiggerItem tool = (DiggerItem)stack.m_41720_();
        int durability = stack.m_41776_();
        if (durability >= 2000) {
            return "legendary";
        }
        if (durability >= 1500) {
            return "epic";
        }
        if (durability >= 300) {
            return "rare";
        }
        if (tool.m_43314_().m_6604_() >= 2) {
            return "rare";
        }
        return "common";
    }

    private static ChatFormatting getColorForRarity(String rarity) {
        return switch (rarity.toLowerCase()) {
            case "rare" -> ChatFormatting.GREEN;
            case "epic" -> ChatFormatting.DARK_PURPLE;
            case "legendary" -> ChatFormatting.GOLD;
            default -> ChatFormatting.GRAY;
        };
    }
}

