/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.recased.config.ConfigHandler;
import net.mint_gaming_studios.recased.events.ItemTooltipHandler;
import net.mint_gaming_studios.recased.tags.ModTags;

public class DynamicItemRegistry {
    private static final Map<ResourceLocation, String> ITEM_RARITIES = new HashMap<ResourceLocation, String>();
    private static final Map<ResourceLocation, String> ITEM_TYPES = new HashMap<ResourceLocation, String>();

    public static void updateRegistry() {
        ITEM_TYPES.clear();
        ITEM_RARITIES.clear();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ResourceLocation itemID;
            if (item == null || (itemID = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            String type = DynamicItemRegistry.determineItemType(stack);
            String rarity = DynamicItemRegistry.determineRarity(stack);
            DynamicItemRegistry.registerItemType(item, type);
            DynamicItemRegistry.registerItemRarity(item, rarity);
        }
    }

    public static List<ResourceLocation> getItemsByType(String itemType) {
        if (itemType == null || itemType.isEmpty()) {
            return Collections.emptyList();
        }
        return ITEM_TYPES.entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(itemType)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static void registerItemType(Item item, String type) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemID != null && type != null && !type.isEmpty()) {
            ITEM_TYPES.put(itemID, DynamicItemRegistry.validateType(type));
        }
    }

    public static void registerItemRarity(Item item, String rarity) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemID != null && rarity != null && !rarity.isEmpty()) {
            ITEM_RARITIES.put(itemID, DynamicItemRegistry.validateRarity(rarity));
        }
    }

    private static String validateRarity(String rarity) {
        List<String> validRarities = Arrays.asList("common", "uncommon", "rare", "epic", "legendary");
        return validRarities.contains(rarity.toLowerCase()) ? rarity.toLowerCase() : "common";
    }

    private static String validateType(String type) {
        return type.toLowerCase();
    }

    public static String getTypeForItem(Item item) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        return itemID != null ? ITEM_TYPES.getOrDefault(itemID, "") : "";
    }

    public static String getRarityForItem(Item item) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        return itemID != null ? ITEM_RARITIES.getOrDefault(itemID, "") : "";
    }

    public static String determineItemType(ItemStack stack) {
        Item item = stack.m_41720_();
        String itemKey = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        ConfigHandler.RarityDefinition specialItem = ConfigHandler.getSpecialItems().get(itemKey);
        if (specialItem != null && specialItem.getType() != null) {
            return specialItem.getType();
        }
        if (item instanceof EnchantedBookItem) {
            if (EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty()) {
                return null;
            }
            return "enchantment";
        }
        if (item instanceof SwordItem || item instanceof TridentItem || item instanceof BowItem || item instanceof CrossbowItem || item.m_204114_().m_203656_(ModTags.ITEMS.WEAPONS) || item.m_204114_().m_203656_(ModTags.ITEMS.RANGED_WEAPONS)) {
            return "weapon";
        }
        if (item instanceof AxeItem || item instanceof PickaxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof DiggerItem || item instanceof ShearsItem || item instanceof FishingRodItem || item instanceof FlintAndSteelItem || item.m_204114_().m_203656_(ModTags.ITEMS.TOOLS)) {
            return "tool";
        }
        if (item instanceof ArmorItem || item.m_204114_().m_203656_(ModTags.ITEMS.ARMORS)) {
            return "armor";
        }
        if (item instanceof ArrowItem || item.m_204114_().m_203656_(ModTags.ITEMS.ARROWS)) {
            return "arrow";
        }
        if (item instanceof PotionItem || item instanceof SplashPotionItem || item instanceof LingeringPotionItem) {
            return "potion";
        }
        if (item.m_41472_() || item.m_204114_().m_203656_(ModTags.ITEMS.FOOD)) {
            return "food";
        }
        return null;
    }

    public static String determineRarity(ItemStack stack) {
        Item item = stack.m_41720_();
        String itemKey = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        ConfigHandler.RarityDefinition specialItem = ConfigHandler.getSpecialItems().get(itemKey);
        if (specialItem != null && specialItem.getRarity() != null) {
            return specialItem.getRarity().toLowerCase();
        }
        if (item instanceof PotionItem || item instanceof SplashPotionItem || item instanceof LingeringPotionItem) {
            return ItemTooltipHandler.calculatePotionRarity(stack);
        }
        if (stack.m_41720_().m_41472_()) {
            return ItemTooltipHandler.calculateFoodRarity(stack);
        }
        if (stack.m_41720_() instanceof SwordItem) {
            return ItemTooltipHandler.calculateSwordRarity(stack);
        }
        if (stack.m_41720_() instanceof DiggerItem) {
            return ItemTooltipHandler.calculateToolRarity(stack);
        }
        if (stack.m_41720_() instanceof ArmorItem) {
            return ItemTooltipHandler.calculateArmorRarity(stack);
        }
        if (stack.m_41720_() instanceof ArrowItem) {
            return ItemTooltipHandler.calculateArrowRarity(stack);
        }
        if (item instanceof EnchantedBookItem) {
            return ItemTooltipHandler.calculateEnchantmentRarity(stack);
        }
        return "common";
    }

    private static String calculatePotionRarity(ItemStack stack) {
        List effects = PotionUtils.m_43547_((ItemStack)stack);
        if (effects.isEmpty()) {
            return "common";
        }
        boolean hasLongDuration = effects.stream().anyMatch(effect -> effect.m_19557_() > 3600);
        boolean hasHighAmplifier = effects.stream().anyMatch(effect -> effect.m_19564_() > 0);
        if (hasLongDuration && hasHighAmplifier) {
            return "legendary";
        }
        if (hasLongDuration || hasHighAmplifier) {
            return "epic";
        }
        return "rare";
    }

    public String getItemRarity(ItemStack stack) {
        return DynamicItemRegistry.determineRarity(stack);
    }

    public int compareByRarity(ItemStack stack1, ItemStack stack2) {
        String rarity1 = this.getItemRarity(stack1);
        String rarity2 = this.getItemRarity(stack2);
        return this.getRarityWeight(rarity1) - this.getRarityWeight(rarity2);
    }

    private int getRarityWeight(String rarity) {
        return switch (rarity.toLowerCase()) {
            case "rare" -> 1;
            case "epic" -> 2;
            case "legendary" -> 3;
            default -> 0;
        };
    }
}

