/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraftforge.fml.loading.FMLPaths;
import net.mint_gaming_studios.recased.config.CustomCaseConfig;
import org.slf4j.Logger;

public class ConfigHandler {
    private static final String CONFIG_PATH = "./config/cases_config.json";
    private static final String SERVER_CONFIG_PATH = "config/cases_config.json";
    private static final String DEFAULT_CONFIG_RESOURCE = "/config/cases_config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Map<String, CustomCaseConfig> customCases = new HashMap<String, CustomCaseConfig>();
    public static List<String> excludedItems = new ArrayList<String>();
    private static Map<String, RarityDefinition> specialItems = new HashMap<String, RarityDefinition>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static DurabilitySettings durabilitySettings = new DurabilitySettings();

    public static DurabilitySettings getDurabilitySettings() {
        return durabilitySettings;
    }

    public static void loadAndCombineConfig() {
        Map<String, Object> defaultConfig = ConfigHandler.loadDefaultConfig();
        Map<String, Object> userConfig = ConfigHandler.loadUserConfig();
        Map<String, Object> serverConfig = ConfigHandler.loadServerConfig();
        HashMap<String, Object> combinedConfig = new HashMap<String, Object>();
        if (defaultConfig != null) {
            combinedConfig.putAll(defaultConfig);
        }
        HashMap finalDurabilitySettings = new HashMap();
        if (defaultConfig != null && defaultConfig.containsKey("durabilitySettings")) {
            finalDurabilitySettings.putAll((Map)defaultConfig.get("durabilitySettings"));
            LOGGER.debug("Default durabilitySettings geladen");
        }
        if (userConfig != null && userConfig.containsKey("durabilitySettings")) {
            finalDurabilitySettings.putAll((Map)userConfig.get("durabilitySettings"));
            LOGGER.debug("User durabilitySettings \u00fcberschreiben Default-Einstellungen");
        }
        if (serverConfig != null && serverConfig.containsKey("durabilitySettings")) {
            finalDurabilitySettings.putAll((Map)serverConfig.get("durabilitySettings"));
            LOGGER.debug("Server durabilitySettings \u00fcberschreiben User-Einstellungen");
        }
        combinedConfig.put("durabilitySettings", finalDurabilitySettings);
        if (userConfig != null) {
            for (Map.Entry<String, Object> entry : userConfig.entrySet()) {
                if ("durabilitySettings".equals(entry.getKey())) continue;
                combinedConfig.put(entry.getKey(), entry.getValue());
            }
        }
        if (serverConfig != null) {
            for (Map.Entry<String, Object> entry : serverConfig.entrySet()) {
                if ("durabilitySettings".equals(entry.getKey())) continue;
                combinedConfig.put(entry.getKey(), entry.getValue());
            }
        }
        ConfigHandler.extractConfig(combinedConfig);
        customCases.clear();
        if (combinedConfig.containsKey("customCases")) {
            JsonElement jsonElement = GSON.toJsonTree(combinedConfig.get("customCases"));
            JsonObject customCasesJson = jsonElement.getAsJsonObject();
            for (Map.Entry entry : customCasesJson.entrySet()) {
                String caseId = (String)entry.getKey();
                JsonObject caseConfig = ((JsonElement)entry.getValue()).getAsJsonObject();
                CustomCaseConfig customCase = new CustomCaseConfig();
                customCase.setId(caseConfig.get("id").getAsInt());
                customCase.setName(caseConfig.get("name").getAsString());
                customCase.setItemType(caseConfig.get("itemType").getAsString());
                customCase.setEnableVillagerTrade(caseConfig.get("enableVillagerTrade").getAsBoolean());
                customCase.setEnableSuspiciousSand(caseConfig.get("enableSuspiciousSand").getAsBoolean());
                JsonArray itemsArray = caseConfig.getAsJsonArray("items");
                ArrayList<String> items = new ArrayList<String>();
                itemsArray.forEach(item -> items.add(item.getAsString()));
                customCase.setItems(items);
                customCases.put(caseId, customCase);
            }
        }
    }

    public static Map<String, CustomCaseConfig> getCustomCases() {
        return customCases;
    }

    private static JsonObject loadConfig() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("cases_config.json");
        try {
            if (Files.exists(configPath, new LinkOption[0])) {
                String content = Files.readString(configPath);
                return (JsonObject)new Gson().fromJson(content, JsonObject.class);
            }
        }
        catch (IOException e) {
            LOGGER.error("Fehler beim Laden der Konfigurationsdatei: ", (Throwable)e);
        }
        return new JsonObject();
    }

    private static void mergeSpecialItems(Map<String, Object> baseConfig, Map<String, Object> overrideConfig) {
        if (overrideConfig.containsKey("specialRankedItems")) {
            Map baseSpecialItems = baseConfig.getOrDefault("specialRankedItems", new HashMap());
            Map overrideSpecialItems = (Map)overrideConfig.get("specialRankedItems");
            baseSpecialItems.putAll(overrideSpecialItems);
            baseConfig.put("specialRankedItems", baseSpecialItems);
        }
    }

    private static void addExcludedItems(Map<String, Object> config, Set<String> excludedItems) {
        List configExcludedItems;
        if (config != null && config.containsKey("excludedItems") && (configExcludedItems = (List)GSON.fromJson(GSON.toJson(config.get("excludedItems")), new TypeToken<List<String>>(){}.getType())) != null) {
            excludedItems.addAll(configExcludedItems);
        }
    }

    private static void loadAdditionalConfigFiles(Set<String> allExcludedItems) {
        String[] additionalConfigFiles;
        for (String configPath : additionalConfigFiles = new String[]{"/data/forge/tags/items/armors.json", "/data/forge/tags/items/arrows.json", "/data/forge/tags/items/food.json", "/data/forge/tags/items/ranged_weapons.json", "/data/forge/tags/items/tools.json", "/data/forge/tags/items/weapons.json"}) {
            try (InputStream resource = ConfigHandler.class.getResourceAsStream(configPath);){
                if (resource == null) continue;
                try (InputStreamReader reader = new InputStreamReader(resource);){
                    JsonObject jsonConfig = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (jsonConfig == null || !jsonConfig.has("values")) continue;
                    JsonArray values = jsonConfig.getAsJsonArray("values");
                    for (JsonElement element : values) {
                        String itemId = element.getAsString();
                        if (itemId.isEmpty()) continue;
                        allExcludedItems.add(itemId);
                        if (!itemId.contains(":")) continue;
                        allExcludedItems.add(itemId.split(":")[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> loadDefaultConfig() {
        try (InputStream resource = ConfigHandler.class.getResourceAsStream(DEFAULT_CONFIG_RESOURCE);){
            Map map;
            if (resource == null) {
                throw new FileNotFoundException("Standardkonfigurationsdatei nicht gefunden: /config/cases_config.json");
            }
            try (InputStreamReader reader = new InputStreamReader(resource);){
                Type configType = new TypeToken<Map<String, Object>>(){}.getType();
                map = (Map)GSON.fromJson((Reader)reader, configType);
            }
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Laden der Standardkonfigurationsdatei!", e);
        }
    }

    private static Map<String, Object> loadUserConfig() {
        Map map;
        File configFile = new File(CONFIG_PATH);
        if (!configFile.exists()) {
            ConfigHandler.generateDefaultConfig();
        }
        FileReader reader = new FileReader(configFile);
        try {
            Type configType = new TypeToken<Map<String, Object>>(){}.getType();
            map = (Map)GSON.fromJson((Reader)reader, configType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Fehler beim Laden der Benutzerkonfiguration!", e);
            }
        }
        ((Reader)reader).close();
        return map;
    }

    private static Map<String, Object> loadServerConfig() {
        Map map;
        File serverConfigFile = new File(SERVER_CONFIG_PATH);
        if (!serverConfigFile.exists()) {
            return null;
        }
        FileReader reader = new FileReader(serverConfigFile);
        try {
            Type configType = new TypeToken<Map<String, Object>>(){}.getType();
            map = (Map)GSON.fromJson((Reader)reader, configType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Fehler beim Laden der Server-Konfiguration: ", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return map;
    }

    private static Map<String, Object> mergeConfigs(Map<String, Object> defaultConfig, Map<String, Object> userConfig) {
        HashMap<String, Object> combined = new HashMap<String, Object>(defaultConfig);
        for (Map.Entry<String, Object> entry : userConfig.entrySet()) {
            if (entry.getValue() instanceof Map && combined.get(entry.getKey()) instanceof Map) {
                Map defaultNestedMap = (Map)combined.get(entry.getKey());
                Map userNestedMap = (Map)entry.getValue();
                combined.put(entry.getKey(), ConfigHandler.mergeConfigs(defaultNestedMap, userNestedMap));
                continue;
            }
            combined.put(entry.getKey(), entry.getValue());
        }
        return combined;
    }

    private static void extractConfig(Map<String, Object> combinedConfig) {
        block11: {
            try {
                Object excludedItemsObj;
                if (combinedConfig.containsKey("excludedItems") && (excludedItemsObj = combinedConfig.get("excludedItems")) instanceof List) {
                    excludedItems = new ArrayList<String>((List)excludedItemsObj);
                }
                if (combinedConfig.containsKey("specialRankedItems")) {
                    specialItems = new HashMap<String, RarityDefinition>();
                    Map specialMap = (Map)combinedConfig.get("specialRankedItems");
                    for (Map.Entry entry : specialMap.entrySet()) {
                        RarityDefinition definition = new RarityDefinition();
                        Map values = (Map)entry.getValue();
                        definition.setRarity((String)values.get("rarity"));
                        definition.setType((String)values.get("type"));
                        if (values.containsKey("amount")) {
                            definition.setAmount((String)values.get("amount"));
                        }
                        specialItems.put((String)entry.getKey(), definition);
                    }
                }
                if (combinedConfig.containsKey("durabilitySettings")) {
                    Map durabilityConfig = (Map)combinedConfig.get("durabilitySettings");
                    durabilitySettings = new DurabilitySettings();
                    if (durabilityConfig.containsKey("disableRandomDurability")) {
                        ConfigHandler.durabilitySettings.disableRandomDurability = (Boolean)durabilityConfig.get("disableRandomDurability");
                    }
                    if (durabilityConfig.containsKey("excludedItems")) {
                        ConfigHandler.durabilitySettings.excludedItems = (List)durabilityConfig.get("excludedItems");
                    }
                    if (durabilityConfig.containsKey("excludedLootCaseTypes")) {
                        ConfigHandler.durabilitySettings.excludedLootCaseTypes = (List)durabilityConfig.get("excludedLootCaseTypes");
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Fehler beim Extrahieren der Konfiguration: ", (Throwable)e);
                if (excludedItems == null) {
                    excludedItems = new ArrayList<String>();
                }
                if (specialItems != null) break block11;
                specialItems = new HashMap<String, RarityDefinition>();
            }
        }
    }

    private static void generateDefaultConfig() {
        try (InputStream resource = ConfigHandler.class.getResourceAsStream(DEFAULT_CONFIG_RESOURCE);){
            if (resource == null) {
                throw new FileNotFoundException("Standardkonfigurationsdatei nicht gefunden: /config/cases_config.json");
            }
            Path parentDir = Path.of(CONFIG_PATH, new String[0]).getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            try (FileOutputStream output = new FileOutputStream(CONFIG_PATH);){
                resource.transferTo(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Erstellen der Standardkonfiguration!", e);
        }
    }

    public static List<String> getExcludedItems() {
        return excludedItems;
    }

    public static Map<String, RarityDefinition> getSpecialItems() {
        return specialItems;
    }

    public static class DurabilitySettings {
        private boolean disableRandomDurability = false;
        private List<String> excludedItems = new ArrayList<String>();
        private List<String> excludedLootCaseTypes = new ArrayList<String>();

        public boolean isRandomDurabilityDisabled() {
            return this.disableRandomDurability;
        }

        public boolean isItemExcluded(String itemId) {
            return this.excludedItems.contains(itemId);
        }

        public boolean isTypeExcluded(String type) {
            return type != null && this.excludedLootCaseTypes.contains(type.toLowerCase());
        }
    }

    public static class RarityDefinition {
        private String rarity;
        private String type;
        public String amount;

        public String getRarity() {
            return this.rarity;
        }

        public void setRarity(String rarity) {
            this.rarity = rarity;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getAmount(RandomSource random) {
            try {
                if (this.amount.contains("-")) {
                    int max;
                    String[] split = this.amount.split("-");
                    int min = Integer.parseInt(split[0].trim());
                    if (min > (max = Integer.parseInt(split[1].trim()))) {
                        throw new IllegalArgumentException("Ung\u00fcltiger Bereich in Amount: " + this.amount);
                    }
                    return random.m_188503_(max - min + 1) + min;
                }
                return Integer.parseInt(this.amount.trim());
            }
            catch (Exception e) {
                System.err.println("[ERROR] Fehler beim Verarbeiten von Amount: '" + this.amount + "' f\u00fcr RarityDefinition.");
                e.printStackTrace();
                return 1;
            }
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
}

