/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.events;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.recased.config.ConfigHandler;

public class ItemManager {
    private static final Map<String, Set<String>> ITEMS_BY_TYPE = new HashMap<String, Set<String>>();

    public static void initializeItemTypes() {
        ITEMS_BY_TYPE.clear();
        ConfigHandler.getSpecialItems().forEach((itemName, rarityDefinition) -> {
            if (!ConfigHandler.getExcludedItems().contains(itemName)) {
                ITEMS_BY_TYPE.computeIfAbsent(rarityDefinition.getType(), type -> new HashSet()).add(itemName);
            }
        });
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            String itemType;
            Item item = (Item)entry.getValue();
            ItemStack stack = new ItemStack((ItemLike)item);
            String itemName2 = ((ResourceKey)entry.getKey()).m_135782_().toString();
            if (ConfigHandler.getExcludedItems().contains(itemName2) || (itemType = ItemManager.determineItemType(stack)) == null) continue;
            ItemManager.addCustomType(stack, itemType);
        }
        ItemManager.logItemsByType();
    }

    public static void addCustomType(ItemStack stack, String itemType) {
        String itemName = ItemManager.getRegistryName(stack);
        ITEMS_BY_TYPE.computeIfAbsent(itemType, k -> new HashSet()).add(itemName);
    }

    public static String determineItemType(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            return "Weapon";
        }
        if (item instanceof ArrowItem) {
            return "Arrow";
        }
        if (item instanceof DiggerItem) {
            return "Tool";
        }
        if (item instanceof ArmorItem) {
            return "Armor";
        }
        if (item instanceof EnchantedBookItem) {
            return "Enchantment";
        }
        if (item instanceof PotionItem) {
            return "Potion";
        }
        if (item.m_41472_()) {
            return "Food";
        }
        return null;
    }

    public static String getRegistryName(ItemStack stack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return itemId != null ? itemId.toString() : "unknown:item";
    }

    public static void logItemsByType() {
        ITEMS_BY_TYPE.forEach((type, items) -> {});
    }

    public static void outputItemsByTypeToChat(ServerPlayer player) {
        if (ITEMS_BY_TYPE.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"No items found to display."));
            return;
        }
        ITEMS_BY_TYPE.forEach((type, items) -> {
            String message = "Type: " + type + " - Items: " + String.join((CharSequence)", ", items);
            player.m_213846_((Component)Component.m_237113_((String)message));
        });
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"listitems").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            if (player != null) {
                ItemManager.outputItemsByTypeToChat(player);
            }
            return 1;
        }));
    }
}

