/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.helper;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.mint_gaming_studios.recased.config.ConfigHandler;
import net.mint_gaming_studios.recased.config.CustomCaseConfig;

public class LangFileGenerator {
    public static void generateLangEntries() {
        HashMap<String, String> langEntries = new HashMap<String, String>();
        for (Map.Entry<String, CustomCaseConfig> entry : ConfigHandler.getCustomCases().entrySet()) {
            String caseId = entry.getKey();
            String name = entry.getValue().getName();
            langEntries.put("item.recased." + caseId + "_case", name);
        }
        LangFileGenerator.generateLangFile(langEntries, "en_us");
        LangFileGenerator.generateLangFile(langEntries, "de_de");
    }

    private static void generateLangFile(Map<String, String> entries, String locale) {
        try {
            Path langPath = Path.of("../src/main/resources/assets/recased/lang/" + locale + ".json", new String[0]);
            Files.createDirectories(langPath.getParent(), new FileAttribute[0]);
            Map<String, String> existingEntries = new HashMap<String, String>();
            if (Files.exists(langPath, new LinkOption[0])) {
                String content = Files.readString(langPath);
                existingEntries = (Map)new Gson().fromJson(content, new TypeToken<Map<String, String>>(){}.getType());
            }
            existingEntries.putAll(entries);
            String json = new GsonBuilder().setPrettyPrinting().create().toJson(existingEntries);
            Files.writeString(langPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

