/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.items;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.NetworkHooks;
import net.mint_gaming_studios.recased.helper.DynamicItemRegistry;
import net.mint_gaming_studios.recased.menu.LootCaseMenuProvider;

public abstract class LootCaseItem
extends Item {
    private final String type;
    private static final Set<String> updatedCaseTypes = new HashSet<String>();

    public LootCaseItem(Item.Properties properties, String type) {
        super(properties);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.RARE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = player.m_21120_(hand);
            if (!updatedCaseTypes.contains(this.type)) {
                DynamicItemRegistry.updateRegistry();
                updatedCaseTypes.add(this.type);
            }
            LootCaseMenuProvider provider = new LootCaseMenuProvider(this.type);
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, buf -> provider.writeToBuffer((FriendlyByteBuf)buf));
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11749_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public abstract void initializeClient(Consumer<IClientItemExtensions> var1);
}

