/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.mint_gaming_studios.recased.ReCased;
import net.mint_gaming_studios.recased.helper.DynamicItemRegistry;
import net.mint_gaming_studios.recased.items.LootCaseItem;
import net.mint_gaming_studios.recased.menu.LootCaseMenu;
import net.mint_gaming_studios.recased.network.RewardSelectedPacket;
import net.mint_gaming_studios.recased.network.SelectFinalRewardPacket;
import net.mint_gaming_studios.recased.network.SyncSlotPacket;

public class LootCaseScreen
extends AbstractContainerScreen<LootCaseMenu> {
    private static final ResourceLocation GUI_TEXTURE_NORMAL = new ResourceLocation("recased", "textures/gui/loot_case.png");
    private static final ResourceLocation GUI_TEXTURE_SPINNING = new ResourceLocation("recased", "textures/gui/loot_case_spinning.png");
    private ResourceLocation currentGuiTexture = GUI_TEXTURE_NORMAL;
    private Button openCrateButton;
    private Button closeButton;
    private Component caseTitle;
    private final int RARE_COLOR = 0x55FF55;
    private final int EPIC_COLOR = 0xAA00AA;
    private final int LEGENDARY_COLOR = 16766720;
    private final int COMMON_COLOR = 0xAAAAAA;
    private boolean isSpinning = false;
    private float currentSpeed = 0.0f;
    private static long lastXylophoneSoundTime = 0L;
    private static final long COOLDOWN_TIME_MS = 40L;
    public static int CASES_OPENED_AMOUNT = 0;
    private boolean isCaseOpened = false;
    private long animationStartTime;
    private static final long ANIMATION_DURATION = 15000L;
    private static final long SLOWDOWN_START_TIME = 10000L;
    private long lastScrollTime;
    private static final float MAX_SPEED = 20.0f;
    private static final long SPEED_UP_DURATION = 1000L;
    private static final long MAX_SPEED_DURATION = 4000L;
    private static final long SLOW_DOWN_DURATION = 3000L;
    private static final long MIN_SLOWDOWN_TIME = 2000L;
    private static final long TOTAL_DURATION = 10000L;

    public LootCaseScreen(LootCaseMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        Player player = inventory.f_35978_;
        ItemStack caseItem = this.findCaseItemInHand(player);
        this.caseTitle = !caseItem.m_41619_() ? caseItem.m_41786_() : Component.m_237113_((String)"Unknown Case");
        this.f_97727_ = 200;
        this.f_97726_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        int guiCenterX = (this.f_96543_ - this.getXSize()) / 2;
        int guiCenterY = (this.f_96544_ - this.getYSize()) / 2;
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), button -> this.m_7379_()).m_252987_(this.f_97735_ + 3, this.f_97736_ + 3, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.openCrateButton = Button.m_253074_((Component)Component.m_237113_((String)"Open Case"), button -> {
            if (!(this.isCaseOpened || this.isSpinning || ((LootCaseMenu)this.f_97732_).isRewardGiven())) {
                this.isCaseOpened = true;
                button.f_93623_ = false;
                this.isSpinning = true;
                this.lastScrollTime = this.animationStartTime = System.currentTimeMillis();
                this.currentSpeed = 2.0f;
                ((LootCaseMenu)this.f_97732_).fillCenterSlotsRandomly();
                this.currentGuiTexture = GUI_TEXTURE_SPINNING;
            }
        }).m_252987_(this.f_97735_ + this.f_97726_ / 2 - 40, this.f_97736_ + 62, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.openCrateButton);
        int slotStartX = this.f_97735_ + this.f_97726_ / 2 - 81 - 152;
        int slotStartY = this.f_97736_ + 100 - 40;
        ((LootCaseMenu)this.f_97732_).setSlotStartPosition(slotStartX, slotStartY);
        this.openCrateButton.f_93623_ = !this.isCaseOpened;
    }

    private ItemStack findCaseItemInHand(Player player) {
        ItemStack itemInHand = player.m_21205_();
        if (itemInHand.m_41720_() instanceof LootCaseItem) {
            return itemInHand;
        }
        return ItemStack.f_41583_;
    }

    private ItemStack neutralizeStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return stack;
        }
        ItemStack displayStack = stack.m_41777_();
        displayStack.m_41764_(1);
        if (displayStack.m_41763_()) {
            displayStack.m_41721_(0);
        }
        return displayStack;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(this.currentGuiTexture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.isSpinning) {
            boolean inSlowdownPhase;
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - this.animationStartTime;
            if (elapsedTime <= 1000L) {
                float progress = (float)elapsedTime / 1000.0f;
                this.currentSpeed = 2.0f + progress * 18.0f;
            } else if (elapsedTime <= 5000L) {
                this.currentSpeed = 20.0f;
            } else if (elapsedTime <= 10000L) {
                float slowdownProgress = (float)(elapsedTime - 5000L) / 3000.0f;
                this.currentSpeed = Math.max(1.0f, 20.0f * (1.0f - slowdownProgress));
                if (this.currentSpeed <= 1.1f && elapsedTime < 8000L) {
                    this.currentSpeed = 1.0f;
                }
            }
            boolean bl = inSlowdownPhase = elapsedTime > 5000L && elapsedTime < 10000L;
            if (this.closeButton != null) {
                boolean bl2 = this.closeButton.f_93623_ = !inSlowdownPhase;
            }
            if ((float)(currentTime - this.lastScrollTime) >= 1000.0f / this.currentSpeed) {
                ((LootCaseMenu)this.f_97732_).scrollCenterSlots();
                this.playXylophoneSound();
                this.lastScrollTime = currentTime;
            }
            if (elapsedTime >= 10000L) {
                this.isSpinning = false;
                this.currentSpeed = 0.0f;
                ReCased.NETWORK.sendToServer((Object)new RewardSelectedPacket());
                this.sendSlotDataToServer(4);
                ReCased.NETWORK.sendToServer((Object)new SelectFinalRewardPacket());
                ItemStack centerItem = ((LootCaseMenu)this.f_97732_).getCenterSlotStack(4);
                String rarity = DynamicItemRegistry.determineRarity(centerItem);
                this.playRewardSound(rarity);
                ((LootCaseMenu)this.f_97732_).selectFinalReward();
                this.closeButton.f_93623_ = true;
            }
        }
        for (int i = 0; i < 9; ++i) {
            int slotX = this.f_97735_ + this.f_97726_ / 2 - 72 + i * 18 - 10;
            int slotY = this.f_97736_ + 40 - 5;
            ItemStack stack = ((LootCaseMenu)this.f_97732_).getCenterSlotStack(i);
            if (!stack.m_41619_()) {
                String rarity;
                int color = switch (rarity = DynamicItemRegistry.determineRarity(stack)) {
                    case "rare" -> 0x55FF55;
                    case "epic" -> 0xAA00AA;
                    case "legendary" -> 16766720;
                    default -> 0xAAAAAA;
                };
                guiGraphics.m_280509_(slotX - 1, slotY - 1, slotX + 17, slotY + 17, color | 0xFF000000);
            }
            guiGraphics.m_280480_(stack, slotX, slotY);
            this.renderStackDetails(guiGraphics, stack, slotX, slotY);
        }
        for (Slot slot : ((LootCaseMenu)this.f_97732_).f_38839_) {
            String rarity;
            ItemStack stack = slot.m_7993_();
            if (((LootCaseMenu)this.f_97732_).isScrollSlot(slot.f_40219_)) {
                stack = this.neutralizeStack(stack);
            }
            int color = switch (rarity = DynamicItemRegistry.determineRarity(stack)) {
                case "rare" -> 0x55FF55;
                case "epic" -> 0xAA00AA;
                case "legendary" -> 16766720;
                default -> 0xAAAAAA;
            };
            int x = this.f_97735_ + slot.f_40220_;
            int y = this.f_97736_ + slot.f_40221_;
            guiGraphics.m_280509_(x - 1, y - 1, x + 17, y + 17, color | 0xFF000000);
            this.renderStackDetails(guiGraphics, stack, x, y);
        }
    }

    private void renderStackDetails(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_41613_() > 1) {
            String countText = String.valueOf(stack.m_41613_());
            int countX = x + 16 - this.f_96547_.m_92895_(countText);
            int countY = y + 12;
            guiGraphics.m_280488_(this.f_96547_, countText, countX, countY, 0xFFFFFF);
        }
        if (stack.m_41763_() && stack.m_41783_() != null) {
            int damage = stack.m_41783_().m_128451_("Damage");
            int maxDurability = stack.m_41776_();
            int durability = maxDurability - damage;
            float durabilityPercentage = (float)durability / (float)maxDurability;
            int barWidth = Math.round(durabilityPercentage * 13.0f);
            int barColor = this.getDurabilityColor(durabilityPercentage);
            guiGraphics.m_280509_(x + 2, y + 13, x + 2 + barWidth, y + 14, barColor);
        }
    }

    private void playRewardSound(String rarity) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            switch (rarity) {
                case "common": {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
                    break;
                }
                case "rare": {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12275_, 1.0f, 1.0f);
                    break;
                }
                case "epic": {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12513_, 1.0f, 1.0f);
                    break;
                }
                case "legendary": {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12496_, 1.0f, 1.0f);
                }
            }
        }
    }

    private int getDurabilityColor(float durabilityPercentage) {
        if ((double)durabilityPercentage > 0.5) {
            return 65280;
        }
        if ((double)durabilityPercentage > 0.25) {
            return 0xFFFF00;
        }
        return 0xFF0000;
    }

    private void sendSlotDataToServer(int slotIndex) {
        ItemStack stack = ((LootCaseMenu)this.f_97732_).centerContainer.m_8020_(slotIndex);
        ReCased.NETWORK.sendToServer((Object)new SyncSlotPacket(slotIndex, stack));
    }

    public boolean m_6913_() {
        if (!this.isSpinning) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.animationStartTime;
        boolean inSlowdownPhase = elapsedTime > 5000L && elapsedTime < 10000L;
        return !inSlowdownPhase;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String title = this.caseTitle.getString();
        int titleX = (this.f_97726_ - this.f_96547_.m_92895_(title)) / 2;
        guiGraphics.m_280488_(this.f_96547_, title, titleX, 6, 0x404040);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            ((LootCaseMenu)this.f_97732_).scroll(1);
        } else if (delta > 0.0) {
            ((LootCaseMenu)this.f_97732_).scroll(-1);
        }
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (((LootCaseMenu)this.f_97732_).isRewardGiven()) {
            for (Renderable widget : this.f_169369_) {
                Button button;
                if (!(widget instanceof Button) || !(button = (Button)widget).m_6035_().getString().equals("Open Case")) continue;
                button.f_93623_ = false;
            }
        }
        this.renderTooltipForSlots(guiGraphics, mouseX, mouseY);
    }

    private void renderTooltipForSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (Slot slot : ((LootCaseMenu)this.f_97732_).f_38839_) {
            if (!this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY) || !slot.m_6657_()) continue;
            ItemStack stack = slot.m_7993_();
            guiGraphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
    }

    private void playXylophoneSound() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastXylophoneSoundTime >= 40L) {
            lastXylophoneSoundTime = currentTime;
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12218_.get(), 1.0f, 1.0f);
        }
    }

    private void playChestCloseSound() {
        Minecraft.m_91087_().f_91074_.m_9236_().m_5594_((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91074_.m_20183_(), SoundEvents.f_11747_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_7379_() {
        Player player = ((LootCaseMenu)this.f_97732_).player;
        this.playChestCloseSound();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof LootCaseItem && ((LootCaseMenu)this.f_97732_).isRewardGiven()) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
        }
        this.currentGuiTexture = GUI_TEXTURE_NORMAL;
        ((LootCaseMenu)this.f_97732_).onCloseMenu();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

