/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis;

import com.feliscape.sanguis.client.book.GuideBookManager;
import com.feliscape.sanguis.client.render.quest.ItemQuestRenderer;
import com.feliscape.sanguis.client.render.quest.KillMobsQuestRenderer;
import com.feliscape.sanguis.client.render.quest.QuestRenderDispatcher;
import com.feliscape.sanguis.client.render.quest.QuestRenderers;
import com.feliscape.sanguis.registry.SanguisQuestTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="sanguis", dist={Dist.CLIENT})
@EventBusSubscriber(modid="sanguis", value={Dist.CLIENT})
public class SanguisClient {
    private static ReloadListener reloadListeners;

    public SanguisClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        QuestRenderers.register(SanguisQuestTypes.FETCH_ITEMS.get(), ItemQuestRenderer::new);
        QuestRenderers.register(SanguisQuestTypes.KILL_MOBS.get(), KillMobsQuestRenderer::new);
    }

    public static ReloadListener reloadListeners() {
        return reloadListeners;
    }

    public static class ReloadListener {
        private final QuestRenderDispatcher questRenderDispatcher;
        private final GuideBookManager guideBookManager;

        public ReloadListener(RegisterClientReloadListenersEvent event) {
            reloadListeners = this;
            Minecraft minecraft = Minecraft.getInstance();
            this.questRenderDispatcher = new QuestRenderDispatcher(Minecraft.getInstance());
            event.registerReloadListener((PreparableReloadListener)this.questRenderDispatcher);
            this.guideBookManager = new GuideBookManager("book");
            event.registerReloadListener((PreparableReloadListener)this.guideBookManager.getChapterCollector());
            event.registerReloadListener((PreparableReloadListener)this.guideBookManager.getEntryCollector());
        }

        public QuestRenderDispatcher getQuestRenderDispatcher() {
            return this.questRenderDispatcher;
        }

        public GuideBookManager getGuideBookManager() {
            return this.guideBookManager;
        }
    }
}

