/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client;

import com.feliscape.sanguis.SanguisClient;
import com.feliscape.sanguis.SanguisServerConfig;
import com.feliscape.sanguis.client.hud.BloodLevelHudLayer;
import com.feliscape.sanguis.client.hud.DrainBarHudLayer;
import com.feliscape.sanguis.client.hud.StatusHudLayer;
import com.feliscape.sanguis.client.render.entity.GoldenQuarrelRenderer;
import com.feliscape.sanguis.client.render.entity.VampireHunterRenderer;
import com.feliscape.sanguis.client.render.entity.VampireRenderer;
import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.networking.payload.BatTransformationPayload;
import com.feliscape.sanguis.networking.payload.DrainBloodPayload;
import com.feliscape.sanguis.networking.payload.OpenActiveQuestsPayload;
import com.feliscape.sanguis.registry.SanguisEntityTypes;
import com.feliscape.sanguis.registry.SanguisKeyMappings;
import com.feliscape.sanguis.util.HunterUtil;
import com.feliscape.sanguis.util.VampireUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="sanguis", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void renderPlayer(RenderLivingEvent.Pre<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> event) {
        LivingEntity entity = event.getEntity();
        float partialTick = event.getPartialTick();
        if (VampireUtil.isBat((Entity)entity)) {
            Bat bat = ((VampireData)entity.getData(VampireData.type())).getBat();
            if (bat == null) {
                return;
            }
            event.setCanceled(true);
            float f = Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)bat, 0.0, 0.0, 0.0, f, partialTick, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    @SubscribeEvent
    public static void renderHand(RenderHandEvent event) {
        if (!VampireUtil.isBat((Entity)Minecraft.getInstance().player)) {
            return;
        }
        if (event.getItemStack().isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        new SanguisClient.ReloadListener(event);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SanguisEntityTypes.VAMPIRE.get(), VampireRenderer::new);
        event.registerEntityRenderer((EntityType)SanguisEntityTypes.VAMPIRE_HUNTER.get(), VampireHunterRenderer::new);
        event.registerEntityRenderer(SanguisEntityTypes.GOLDEN_QUARREL.get(), GoldenQuarrelRenderer::new);
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.EXPERIENCE_LEVEL, StatusHudLayer.LOCATION, (LayeredDraw.Layer)new StatusHudLayer());
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, BloodLevelHudLayer.LOCATION, (LayeredDraw.Layer)new BloodLevelHudLayer());
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, DrainBarHudLayer.LOCATION, (LayeredDraw.Layer)new DrainBarHudLayer());
    }

    @SubscribeEvent
    public static void skipRenderingFoodBar(RenderGuiLayerEvent.Pre event) {
        if (VampireUtil.isVampire((Entity)Minecraft.getInstance().player) && event.getName() == VanillaGuiLayers.FOOD_LEVEL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void beforeClientTick(ClientTickEvent.Pre event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player.hasData(VampireData.type())) {
            VampireData data = (VampireData)player.getData(VampireData.type());
            data.clientTick();
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        LocalPlayer player = minecraft.player;
        boolean triggered = false;
        while (((KeyMapping)SanguisKeyMappings.DRAIN_BLOOD.get()).consumeClick()) {
            EntityHitResult hitResult;
            Entity target;
            if (triggered || minecraft.hitResult == null || minecraft.hitResult.getType() != HitResult.Type.ENTITY || !((double)player.distanceTo(target = (hitResult = (EntityHitResult)minecraft.hitResult).getEntity()) <= SanguisServerConfig.CONFIG.vampireDrainDistance.getAsDouble())) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new DrainBloodPayload(target.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            triggered = true;
        }
        while (((KeyMapping)SanguisKeyMappings.BAT_TRANSFORMATION.get()).consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new BatTransformationPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (((KeyMapping)SanguisKeyMappings.OPEN_ACTIVE_QUESTS.get()).consumeClick()) {
            if (!HunterUtil.isHunter((Entity)player)) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenActiveQuestsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

