/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.model.VampireHunterModel;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="sanguis", value={Dist.CLIENT})
public class SanguisModelLayers {
    private static final Set<ModelLayerLocation> ALL_MODELS = Sets.newHashSet();
    public static final ModelLayerLocation VAMPIRE = SanguisModelLayers.register("vampire");
    public static final ModelLayerLocation VAMPIRE_ARMOR_OUTER = SanguisModelLayers.registerOuterArmor("vampire");
    public static final ModelLayerLocation VAMPIRE_ARMOR_INNER = SanguisModelLayers.registerInnerArmor("vampire");
    public static final ModelLayerLocation VAMPIRE_HUNTER = SanguisModelLayers.register("vampire_hunter");
    public static final CubeDeformation OUTER_ARMOR_DEFORMATION = new CubeDeformation(1.0f);
    public static final CubeDeformation INNER_ARMOR_DEFORMATION = new CubeDeformation(0.5f);

    private static ModelLayerLocation register(String path) {
        return SanguisModelLayers.register(path, "main");
    }

    private static ModelLayerLocation registerInnerArmor(String path) {
        return SanguisModelLayers.register(path, "inner_armor");
    }

    private static ModelLayerLocation registerOuterArmor(String path) {
        return SanguisModelLayers.register(path, "outer_armor");
    }

    private static ModelLayerLocation register(String path, String model) {
        ModelLayerLocation modellayerlocation = SanguisModelLayers.createLocation(path, model);
        if (!ALL_MODELS.add(modellayerlocation)) {
            throw new IllegalStateException("Duplicate registration for " + String.valueOf(modellayerlocation));
        }
        return modellayerlocation;
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(Sanguis.location(path), model);
    }

    public static Stream<ModelLayerLocation> getKnownLocations() {
        return ALL_MODELS.stream();
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition outerArmor = LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)OUTER_ARMOR_DEFORMATION), (int)64, (int)32);
        LayerDefinition innerArmor = LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)INNER_ARMOR_DEFORMATION), (int)64, (int)32);
        event.registerLayerDefinition(VAMPIRE, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f), (int)64, (int)64));
        event.registerLayerDefinition(VAMPIRE_ARMOR_OUTER, () -> outerArmor);
        event.registerLayerDefinition(VAMPIRE_ARMOR_INNER, () -> innerArmor);
        event.registerLayerDefinition(VAMPIRE_HUNTER, VampireHunterModel::createBodyLayer);
    }
}

