/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.book;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.book.BookLink;
import com.feliscape.sanguis.client.book.widget.BookWidget;
import com.feliscape.sanguis.client.screen.GuideBookScreen;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.commons.io.IOUtils;

public class BookEntry {
    public static final ResourceLocation EMPTY = Sanguis.location("empty");
    public static final Codec<BookEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ComponentSerialization.CODEC.fieldOf("title").forGetter(entry -> entry.title), (App)ResourceLocation.CODEC.fieldOf("chapter").forGetter(entry -> entry.chapter), (App)ResourceLocation.CODEC.lenientOptionalFieldOf("parent", (Object)EMPTY).forGetter(entry -> entry.parent), (App)ResourceLocation.CODEC.lenientOptionalFieldOf("text", (Object)EMPTY).forGetter(entry -> entry.text), (App)ResourceLocation.CODEC.lenientOptionalFieldOf("art", (Object)EMPTY).forGetter(entry -> entry.art), (App)BookWidget.TYPED_CODEC.listOf().optionalFieldOf("widgets", List.of()).forGetter(entry -> entry.widgets)).apply((Applicative)inst, BookEntry::new));
    private Component title;
    private ResourceLocation chapter;
    private ResourceLocation parent;
    private ResourceLocation text;
    private ResourceLocation art;
    private static Pattern linkPattern = Pattern.compile("\\{.*?}");
    private List<BookWidget> widgets;
    private int pageCount;
    private List<String> entryText = new ArrayList<String>();
    private List<BookLink> bookLinks = new ArrayList<BookLink>();

    public BookEntry(Component title, ResourceLocation chapter, ResourceLocation parent, ResourceLocation text, ResourceLocation art, List<BookWidget> widgets) {
        this.title = title;
        this.chapter = chapter;
        this.parent = parent;
        this.text = text;
        this.art = art;
        this.widgets = widgets;
    }

    public static String getBookFileDirectory() {
        return "book/";
    }

    public void init(GuideBookScreen screen) {
        this.entryText = this.resolveText(this.text, 40);
        this.pageCount = Mth.ceil((float)((float)this.entryText.size() / 36.0f));
    }

    private List<String> resolveText(ResourceLocation location, int maxLineSize) {
        ResourceLocation fileRes;
        if (location == EMPTY) {
            return List.of();
        }
        String lang = Minecraft.getInstance().getLanguageManager().getSelected().toLowerCase();
        try {
            fileRes = location.withPrefix(BookEntry.getBookFileDirectory() + lang + "/");
            InputStream stream = Minecraft.getInstance().getResourceManager().open(fileRes);
            stream.close();
        }
        catch (Exception e) {
            Sanguis.LOGGER.warn("Could not find language file for translation, defaulting to en_us");
            fileRes = location.withPrefix(BookEntry.getBookFileDirectory() + "en_us/");
        }
        ArrayList<String> strings = new ArrayList<String>();
        Font font = Minecraft.getInstance().font;
        try {
            BufferedReader reader = Minecraft.getInstance().getResourceManager().openAsReader(fileRes);
            List readIn = IOUtils.readLines((Reader)reader);
            int currentLineCount = 0;
            this.bookLinks.clear();
            for (String readString : readIn) {
                if (readString.equals("[PAGEBREAK]")) {
                    int linesToAdd = 18 - strings.size() % 18;
                    for (int i = 0; i < linesToAdd; ++i) {
                        strings.add("");
                        ++currentLineCount;
                    }
                    continue;
                }
                Matcher matcher = linkPattern.matcher(readString);
                boolean skipLine = false;
                boolean noOverflow = false;
                while (matcher.find()) {
                    String[] found = matcher.group().split("\\|");
                    String display = "";
                    if (found.length >= 1) {
                        String linkTo = found[1].substring(0, found[1].length() - 1);
                        display = found[0].substring(1);
                        this.bookLinks.add(new BookLink(currentLineCount, matcher.start(), display, ResourceLocation.parse((String)linkTo), true));
                        readString = matcher.replaceFirst(display);
                    } else {
                        readString = display;
                        skipLine = true;
                    }
                    noOverflow = true;
                }
                if (readString.isEmpty() && !skipLine) {
                    strings.add(readString);
                    ++currentLineCount;
                }
                while (font.width(readString) > 140) {
                    int lastSpace = -1;
                    int selectedSpace = -1;
                    for (int spaceScanIndex = 0; spaceScanIndex < readString.length(); ++spaceScanIndex) {
                        if (font.width(readString.substring(0, spaceScanIndex)) > 140) {
                            selectedSpace = noOverflow ? readString.length() : lastSpace;
                            break;
                        }
                        if (readString.charAt(spaceScanIndex) != ' ') continue;
                        lastSpace = spaceScanIndex;
                    }
                    int cutIndex = selectedSpace == -1 ? Math.min(maxLineSize, readString.length()) : selectedSpace;
                    strings.add(readString.substring(0, cutIndex));
                    ++currentLineCount;
                    if (!(readString = readString.substring(cutIndex)).startsWith(" ")) continue;
                    readString = readString.substring(1);
                }
                if (readString.isEmpty()) continue;
                strings.add(readString);
                ++currentLineCount;
            }
        }
        catch (Exception e) {
            Sanguis.LOGGER.debug("Encountered an error while trying to load text file {}", (Object)location);
            e.printStackTrace();
        }
        return strings;
    }

    public void mouseOver(GuideBookScreen screen, int page, double mouseX, double mouseY) {
        boolean hoverFlag = false;
        for (BookLink link : this.bookLinks) {
            boolean startsOnLeft;
            int minLine = page * 18;
            link.setHovered(false);
            if (link.getLineNumber() < minLine || link.getLineNumber() >= minLine + 36) continue;
            String line = this.entryText.get(link.getLineNumber());
            boolean bl = startsOnLeft = this.art == EMPTY;
            int textStartX = startsOnLeft ? (link.getLineNumber() > minLine + 18 ? 172 : 24) : (link.getLineNumber() > minLine + 18 ? 24 : 172);
            int wordLength = Minecraft.getInstance().font.width(link.getDisplayText());
            int wordTop = 14 + link.getLineNumber() % 18 * 10;
            int wordLeft = textStartX + Minecraft.getInstance().font.width(line.substring(0, link.getCharacterStartsAt()));
            if (!this.isHovering(screen.getGuiLeft(), screen.getGuiTop(), wordLeft, wordTop, wordLength, 8, mouseX, mouseY)) continue;
            link.setHovered(!hoverFlag);
            hoverFlag = true;
        }
    }

    public boolean mouseClick(GuideBookScreen screen, int page, double mouseX, double mouseY) {
        for (BookLink link : this.bookLinks) {
            int minLine = page * 18;
            if (!link.isEnabled() || !link.isHovered() || link.getLineNumber() < minLine || link.getLineNumber() > minLine + 36) continue;
            screen.openEntry(link.getLinksTo());
            return true;
        }
        return false;
    }

    protected boolean isHovering(int leftPos, int topPos, int x, int y, int width, int height, double mouseX, double mouseY) {
        return (mouseX -= (double)leftPos) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)topPos) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public Component getTitle() {
        return this.title;
    }

    public ResourceLocation getChapter() {
        return this.chapter;
    }

    public ResourceLocation getParent() {
        return this.parent;
    }

    public ResourceLocation getText() {
        return this.text;
    }

    public ResourceLocation getArt() {
        return this.art;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public List<String> getEntryText() {
        return this.entryText;
    }

    public List<BookLink> getBookLinks() {
        return this.bookLinks;
    }

    public List<BookWidget> getWidgets() {
        return this.widgets;
    }
}

