/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.book;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.book.BookChapter;
import com.feliscape.sanguis.client.book.BookEntry;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GuideBookManager {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation ROOT_LOCATION = Sanguis.location("root");
    private ChapterCollector chapterCollector;
    private EntryCollector entryCollector;

    public GuideBookManager(String directory) {
        this.chapterCollector = new ChapterCollector(directory + "/chapter");
        this.entryCollector = new EntryCollector(directory + "/entry");
    }

    public ChapterCollector getChapterCollector() {
        return this.chapterCollector;
    }

    public EntryCollector getEntryCollector() {
        return this.entryCollector;
    }

    @Nullable
    public BookEntry getEntry(ResourceLocation location) {
        return this.entryCollector.entries.getOrDefault(location, null);
    }

    @Nullable
    public BookChapter getChapter(ResourceLocation location) {
        return this.chapterCollector.chapters.getOrDefault(location, null);
    }

    @Nullable
    public BookChapter getChapter(int index) {
        if (index < 0 || index >= this.chapterCollector.chapterList.size()) {
            return null;
        }
        return this.chapterCollector.chapterList.get(index);
    }

    public List<BookChapter> getAllChapters() {
        return this.chapterCollector.chapterList;
    }

    public static class ChapterCollector
    extends SimpleJsonResourceReloadListener {
        protected Map<ResourceLocation, BookChapter> chapters = ImmutableMap.of();
        protected List<BookChapter> chapterList = List.of();

        public ChapterCollector(String directory) {
            super(GSON, directory);
        }

        protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<ResourceLocation, JsonElement> jsonEntry : object.entrySet()) {
                ResourceLocation location = jsonEntry.getKey();
                JsonElement json = jsonEntry.getValue();
                try {
                    BookChapter entry = (BookChapter)BookChapter.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
                    builder.put((Object)location, (Object)entry);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load book chapter {}", (Object)location, (Object)e);
                }
            }
            this.chapters = builder.build();
            this.chapterList = new ArrayList<BookChapter>(this.chapters.values());
            LOGGER.debug("Loaded {} book chapters", (Object)this.chapters.size());
        }
    }

    public static class EntryCollector
    extends SimpleJsonResourceReloadListener {
        protected Map<ResourceLocation, BookEntry> entries = ImmutableMap.of();

        public EntryCollector(String directory) {
            super(GSON, directory);
        }

        protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<ResourceLocation, JsonElement> jsonEntry : object.entrySet()) {
                ResourceLocation location = jsonEntry.getKey();
                JsonElement json = jsonEntry.getValue();
                try {
                    BookEntry entry = (BookEntry)BookEntry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
                    builder.put((Object)location, (Object)entry);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load book entry {}", (Object)location, (Object)e);
                }
            }
            this.entries = builder.build();
            LOGGER.debug("Loaded {} book entries", (Object)this.entries.size());
        }
    }
}

