/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.book.chapter;

import com.feliscape.sanguis.client.book.chapter.ChapterEntry;
import com.feliscape.sanguis.client.book.chapter.ChapterEntryType;
import com.feliscape.sanguis.registry.SanguisChapterEntryTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class PlainChapterEntry
extends ChapterEntry {
    public static final Component DASH = Component.literal((String)"- ");
    public static final MapCodec<PlainChapterEntry> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ComponentSerialization.CODEC.fieldOf("title").forGetter(PlainChapterEntry::getTitle), (App)ItemStack.CODEC.optionalFieldOf("icon", (Object)ItemStack.EMPTY).forGetter(PlainChapterEntry::getIcon), (App)Codec.INT.optionalFieldOf("indent", (Object)0).forGetter(PlainChapterEntry::getIndent)).apply((Applicative)inst, PlainChapterEntry::new));
    protected Component title;
    protected ItemStack icon;
    protected int indent;

    public PlainChapterEntry(Component title, ItemStack icon, int indent) {
        this.title = title;
        this.icon = icon;
        this.indent = indent;
    }

    public Component getTitle() {
        return this.title;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public int getIndent() {
        return this.indent;
    }

    @Override
    public ChapterEntryType<?> type() {
        return SanguisChapterEntryTypes.PLAIN.get();
    }

    @Override
    public int render(int x, int y, int i, GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        ItemStack icon = this.getIcon();
        x += this.getIndent() * 8;
        if (icon.isEmpty()) {
            guiGraphics.drawString(font, DASH, x, y, 0x3F3F3F, false);
            guiGraphics.drawString(font, this.getTitle(), x + 14, y, 0x3F3F3F, false);
        } else {
            guiGraphics.drawString(font, DASH, x, y, 0x3F3F3F, false);
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.scale(0.6667f, 0.6667f, 0.6667f);
            poseStack.translate((float)(x += font.width((FormattedText)DASH) - 3) / 0.6667f, (float)(y - 2) / 0.6667f, 0.0f);
            guiGraphics.renderItem(icon, 0, 0);
            poseStack.popPose();
            guiGraphics.drawString(font, this.getTitle(), x + 14, y, 0x3F3F3F, false);
        }
        return y += 12;
    }
}

