/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.book.widget;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.book.widget.BookWidget;
import com.feliscape.sanguis.client.book.widget.WidgetType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingRecipeWidget
extends BookWidget {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CRAFTING_GRID = Sanguis.location("textures/gui/guide_book/crafting_grid.png");
    private static final ResourceLocation CRAFTING_GRID_2X2 = Sanguis.location("textures/gui/guide_book/crafting_grid_2x2.png");
    public static final MapCodec<CraftingRecipeWidget> CODEC = RecordCodecBuilder.mapCodec(inst -> CraftingRecipeWidget.codecStart(inst).and((App)ResourceLocation.CODEC.fieldOf("recipe").forGetter(CraftingRecipeWidget::getRecipeId)).apply((Applicative)inst, CraftingRecipeWidget::new));
    private ResourceLocation recipeId;

    public CraftingRecipeWidget(int displayPage, WidgetType<?> type, int x, int y, ResourceLocation recipeId) {
        super(displayPage, type, x, y);
        this.recipeId = recipeId;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        Recipe<?> recipe = this.getRecipe(this.getRecipeId());
        x += this.getX();
        y += this.getY();
        if (recipe == null || Minecraft.getInstance().level == null) {
            return;
        }
        float playerTicks = Minecraft.getInstance().player.tickCount;
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            if (craftingRecipe.canCraftInDimensions(2, 2)) {
                guiGraphics.blit(CRAFTING_GRID_2X2, x, y, 0, 0.0f, 0.0f, 116, 54, 116, 54);
                NonNullList ingredients = craftingRecipe.getIngredients();
                int width = 2;
                int height = 2;
                if (craftingRecipe instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)craftingRecipe;
                    width = shaped.getWidth();
                    height = shaped.getHeight();
                }
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ingredient = (Ingredient)ingredients.get(i);
                    if (ingredient.isEmpty()) continue;
                    ItemStack itemStack = ingredient.getItems()[(int)(playerTicks / 20.0f % (float)ingredient.getItems().length)];
                    guiGraphics.renderItem(itemStack, x + 9 + i % width * 17, y + 10 + Mth.floor((float)((float)i / (float)height)) * 17 + (2 - height) * 17);
                }
                guiGraphics.renderItem(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), x + 88, y + 19);
            } else {
                guiGraphics.blit(CRAFTING_GRID, x, y, 0, 0.0f, 0.0f, 116, 54, 116, 54);
                NonNullList ingredients = craftingRecipe.getIngredients();
                int width = 3;
                int height = 3;
                if (craftingRecipe instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)craftingRecipe;
                    width = shaped.getWidth();
                    height = shaped.getHeight();
                }
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ingredient = (Ingredient)ingredients.get(i);
                    if (ingredient.isEmpty()) continue;
                    ItemStack itemStack = ingredient.getItems()[(int)(playerTicks / 20.0f % (float)ingredient.getItems().length)];
                    guiGraphics.renderItem(itemStack, x + 2 + (i % width + (width == 1 ? 1 : 0)) * 17, y + 2 + Mth.floor((float)((float)i / (float)width)) * 17 + (3 - height) * 17);
                }
                guiGraphics.renderItem(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), x + 95, y + 19);
            }
        }
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    private Recipe<?> getRecipe(ResourceLocation location) {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        try {
            RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
            Optional recipeOptional = manager.byKey(this.recipeId);
            if (recipeOptional.isPresent()) {
                return ((RecipeHolder)recipeOptional.get()).value();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not find recipe {} due to an unexpected error", (Object)location, (Object)e);
        }
        return null;
    }
}

