/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.hud;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.hud.HudLayer;
import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.util.VampireUtil;
import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BloodLevelHudLayer
extends HudLayer {
    public static final ResourceLocation LOCATION = Sanguis.location("blood_level");
    private static final ResourceLocation BLOOD_EMPTY_SPRITE = Sanguis.location("hud/blood_empty");
    private static final ResourceLocation BLOOD_HALF_SPRITE = Sanguis.location("hud/blood_half");
    private static final ResourceLocation BLOOD_FULL_SPRITE = Sanguis.location("hud/blood_full");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!this.canRenderOverlay() || this.player().isSpectator()) {
            return;
        }
        if (VampireUtil.isVampire((Entity)this.player()) && this.minecraft.gameMode.hasExperience()) {
            LivingEntity livingentity = this.getPlayerVehicleWithHealth();
            int vehicleMaxHearts = this.getVehicleMaxHearts(livingentity);
            if (vehicleMaxHearts > 0) {
                return;
            }
            int left = guiGraphics.guiWidth() / 2 + 91;
            int top = guiGraphics.guiHeight() - this.minecraft.gui.rightHeight;
            this.minecraft.gui.rightHeight += 10;
            int blood = ((VampireData)this.player().getData(VampireData.type())).getBloodData().getBlood();
            for (int i = 0; i < 10; ++i) {
                int x = left - i * 8 - 9;
                guiGraphics.blitSprite(BLOOD_EMPTY_SPRITE, x, top, 9, 9);
                if (i * 2 + 1 < blood) {
                    guiGraphics.blitSprite(BLOOD_FULL_SPRITE, x, top, 9, 9);
                }
                if (i * 2 + 1 != blood) continue;
                guiGraphics.blitSprite(BLOOD_HALF_SPRITE, x, top, 9, 9);
            }
        }
    }

    @Nullable
    private Player getCameraPlayer() {
        Player player;
        Entity entity = this.minecraft.getCameraEntity();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    @Nullable
    private LivingEntity getPlayerVehicleWithHealth() {
        Player player = this.getCameraPlayer();
        if (player != null) {
            Entity entity = player.getVehicle();
            if (entity == null) {
                return null;
            }
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    private int getVehicleMaxHearts(@Nullable LivingEntity vehicle) {
        if (vehicle != null && vehicle.showVehicleHealth()) {
            float f = vehicle.getMaxHealth();
            int i = (int)(f + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }
}

