/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.hud;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.hud.HudLayer;
import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.util.HunterUtil;
import com.feliscape.sanguis.util.VampireUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class StatusHudLayer
extends HudLayer {
    public static final ResourceLocation LOCATION = Sanguis.location("vampire_status");
    private static final ResourceLocation INFECTED_SPRITE = Sanguis.location("hud/status/infected");
    private static final ResourceLocation VAMPIRE_SPRITE = Sanguis.location("hud/status/vampire");
    private static final ResourceLocation BAT_SPRITE = Sanguis.location("hud/status/bat");
    private static final ResourceLocation HUNTER_SPRITE = Sanguis.location("hud/status/hunter");

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int tier;
        if (!this.canRenderOverlay() || this.player().isSpectator()) {
            return;
        }
        ResourceLocation location = null;
        if (VampireUtil.isInfected((Entity)this.player())) {
            location = INFECTED_SPRITE;
        } else if (VampireUtil.isBat((Entity)this.player())) {
            location = BAT_SPRITE;
        } else if (VampireUtil.isVampire((Entity)this.player())) {
            location = VAMPIRE_SPRITE;
        } else if (HunterUtil.isHunter((Entity)this.player())) {
            location = HUNTER_SPRITE;
        }
        if (location == null) {
            return;
        }
        int x = (guiGraphics.guiWidth() - 19) / 2;
        int y = guiGraphics.guiHeight() - 36 - this.getHeight(this.player());
        guiGraphics.blitSprite(location, x, y, 19, 15);
        if (VampireUtil.isVampire((Entity)this.player()) && (tier = ((VampireData)this.player().getData(VampireData.type())).getTier()) > 0) {
            String s = "" + tier;
            int j = (guiGraphics.guiWidth() - this.minecraft.font.width(s)) / 2;
            int k = guiGraphics.guiHeight() - 31 - this.getLevelHeight(this.player());
            guiGraphics.drawString(this.minecraft.font, s, j + 1, k, 0, false);
            guiGraphics.drawString(this.minecraft.font, s, j - 1, k, 0, false);
            guiGraphics.drawString(this.minecraft.font, s, j, k + 1, 0, false);
            guiGraphics.drawString(this.minecraft.font, s, j, k - 1, 0, false);
            guiGraphics.drawString(this.minecraft.font, s, j, k, 12132685, false);
        }
    }

    private int getHeight(LocalPlayer player) {
        if (!this.isAnyBarVisible()) {
            return -2;
        }
        int i = player.experienceLevel;
        if (i == 0) {
            return 4;
        }
        int y = 7;
        if (Integer.toString(i).length() > 2) {
            y += 2;
        }
        return y;
    }

    private int getLevelHeight(LocalPlayer player) {
        if (!this.isAnyBarVisible()) {
            return -2;
        }
        int i = player.experienceLevel;
        if (i == 0) {
            return 4;
        }
        return 14;
    }

    private boolean isAnyBarVisible() {
        return this.minecraft.gameMode.hasExperience();
    }

    private boolean isExperienceBarVisible() {
        return this.minecraft.player.jumpableVehicle() == null && this.minecraft.gameMode.hasExperience();
    }
}

