/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.registry;

import com.feliscape.sanguis.client.book.widget.WidgetType;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class WidgetTypeRegistry {
    public static final Codec<WidgetType<?>> CODEC = ResourceLocation.CODEC.comapFlatMap(location -> WidgetTypeRegistry.getType(location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in WidgetTypeRegistry: " + String.valueOf(location))), t -> t.location());
    private static final Map<ResourceLocation, WidgetType<?>> registry = Maps.newHashMap();

    public static void register(ResourceLocation location, WidgetType<?> type) {
        if (registry.containsKey(location)) {
            throw new IllegalStateException("Duplicate widget type registration: " + String.valueOf(location));
        }
        registry.put(location, type);
    }

    public static Optional<WidgetType<?>> getType(ResourceLocation location) {
        return Optional.ofNullable(registry.get(location));
    }
}

