/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.render.quest;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.render.quest.QuestRenderer;
import com.feliscape.sanguis.content.quest.KillMobsQuest;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class KillMobsQuestRenderer
extends QuestRenderer<KillMobsQuest> {
    private static final ResourceLocation PROGRESS_BACKGROUND = Sanguis.location("container/quests/progress_bar_background");
    private static final ResourceLocation PROGRESS_FILL = Sanguis.location("container/quests/progress_bar_fill");

    public KillMobsQuestRenderer(Minecraft minecraft) {
        super(minecraft);
    }

    @Override
    public void renderActive(KillMobsQuest quest, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, boolean canRenderTooltip) {
        ArrayList requiredKillSet = new ArrayList(quest.getRequiredKills().entrySet());
        for (int i = 0; i < requiredKillSet.size(); ++i) {
            Map.Entry<EntityType<?>, Integer> entry = requiredKillSet.get(i);
            int offsetY = y + i * 17;
            Integer kills = quest.getKills().getOrDefault(entry.getKey(), 0);
            Integer requiredKills = entry.getValue();
            MutableComponent component = Component.translatable((String)entry.getKey().getDescriptionId()).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"  %s/%s".formatted(kills, requiredKills)).withStyle(ChatFormatting.GRAY));
            guiGraphics.drawString(this.minecraft.font, (Component)component, x, offsetY, -1);
            guiGraphics.blitSprite(PROGRESS_BACKGROUND, x, offsetY + 12, 121, 5);
            if (!quest.getKills().containsKey(entry.getKey())) continue;
            int fill = (int)((float)kills.intValue() / (float)requiredKills.intValue() * 121.0f);
            guiGraphics.blitSprite(PROGRESS_FILL, 121, 5, 0, 0, x, offsetY + 12, Math.min(fill, 121), 5);
        }
    }

    @Override
    public void renderChoice(KillMobsQuest quest, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, boolean canRenderTooltip) {
        ArrayList requiredKillSet = new ArrayList(quest.getRequiredKills().entrySet());
        for (int i = 0; i < requiredKillSet.size(); ++i) {
            Map.Entry<EntityType<?>, Integer> entry = requiredKillSet.get(i);
            int offsetY = y + i * 12;
            Integer requiredKills = entry.getValue();
            MutableComponent component = Component.translatable((String)entry.getKey().getDescriptionId()).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)" x%s".formatted(requiredKills)).withStyle(ChatFormatting.GRAY));
            guiGraphics.drawString(this.minecraft.font, (Component)component, x, offsetY, -1);
        }
    }
}

