/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.render.quest;

import com.feliscape.sanguis.client.render.quest.QuestRenderer;
import com.feliscape.sanguis.client.render.quest.QuestRenderers;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class QuestRenderDispatcher
implements ResourceManagerReloadListener {
    private Map<QuestType<?>, QuestRenderer<?>> renderers = ImmutableMap.of();
    private final Minecraft minecraft;

    public QuestRenderDispatcher(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    @Nullable
    public <T extends HunterQuest> QuestRenderer<? super T> getRenderer(T requirement) {
        return this.renderers.get(requirement.type());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.renderers = QuestRenderers.createRenderers(this.minecraft);
    }

    public <Q extends HunterQuest> void render(Q quest, int x, int y, int mouseX, int mouseY, boolean canRenderTooltip, GuiGraphics guiGraphics) {
        QuestRenderer<Q> renderer = this.getRenderer(quest);
        if (renderer == null) {
            return;
        }
        renderer.renderActive(quest, guiGraphics, x, y, mouseX, mouseY, canRenderTooltip);
    }

    public <Q extends HunterQuest> void renderChoice(Q quest, int x, int y, int mouseX, int mouseY, boolean canRenderTooltip, GuiGraphics guiGraphics) {
        QuestRenderer<Q> renderer = this.getRenderer(quest);
        if (renderer == null) {
            return;
        }
        renderer.renderChoice(quest, guiGraphics, x, y, mouseX, mouseY, canRenderTooltip);
    }
}

