/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.render.quest;

import com.feliscape.sanguis.client.render.quest.QuestRenderer;
import com.feliscape.sanguis.client.render.quest.QuestRendererProvider;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.registry.custom.SanguisRegistries;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class QuestRenderers {
    private static final Map<QuestType<?>, QuestRendererProvider<?>> PROVIDERS = new Object2ObjectOpenHashMap();

    public static <T extends HunterQuest> void register(QuestType<T> type, QuestRendererProvider<T> provider) {
        PROVIDERS.put(type, provider);
    }

    public static Map<QuestType<?>, QuestRenderer<?>> createRenderers(Minecraft minecraft) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PROVIDERS.forEach((type, factory) -> {
            try {
                builder.put(type, factory.create(minecraft));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create renderer for " + String.valueOf(SanguisRegistries.QUEST_TYPES.getKey(type)), exception);
            }
        });
        return builder.build();
    }
}

