/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.screen;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.client.screen.QuestInformationComponent;
import com.feliscape.sanguis.content.attachment.HunterQuestData;
import com.feliscape.sanguis.content.menu.ActiveQuestsMenu;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.util.QuestUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class ActiveQuestsScreen
extends AbstractContainerScreen<ActiveQuestsMenu> {
    private static final ResourceLocation BACKGROUND_LOCATION = Sanguis.location("textures/gui/container/active_quests.png");
    private static final ResourceLocation QUEST_BACKGROUND_UNSELECTED = Sanguis.location("container/quests/quest_background_unselected");
    private static final ResourceLocation QUEST_BACKGROUND_SELECTED = Sanguis.location("container/quests/quest_background_selected");
    int scrollOffset;
    int selectedIndex = -1;
    private final QuestInformationComponent questInformation = new QuestInformationComponent();
    private boolean widthTooNarrow;

    public ActiveQuestsScreen(ActiveQuestsMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.questInformation.setVisible(false);
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 212;
        super.init();
        this.titleLabelX = 10000;
        this.inventoryLabelY = this.imageHeight - 94;
        this.leftPos = this.questInformation.updateScreenPosition(this.width, this.imageWidth);
        this.widthTooNarrow = this.width < 379;
        this.questInformation.init(this.width, this.height, this.minecraft, this.widthTooNarrow, this);
        this.addWidget(this.questInformation);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (((ActiveQuestsMenu)this.menu).data == null) {
            return false;
        }
        if ((scrollY = Mth.clamp((double)scrollY, (double)-1.0, (double)1.0)) != 0.0) {
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset + Mth.ceil((double)Math.abs(scrollY)) * -Mth.sign((double)scrollY)), (int)0, (int)(((ActiveQuestsMenu)this.menu).data.getActiveQuests().size() - 4));
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((ActiveQuestsMenu)this.menu).data == null) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.questInformation.mouseClicked(mouseX, mouseY, button)) {
            this.questInformation.setFocused(true);
            return true;
        }
        this.selectedIndex = -1;
        for (int i = 0; i < 3; ++i) {
            int index;
            if (!this.isHovering(16, 13 + i * 25, 144, 25, mouseX, mouseY) || (index = i + this.scrollOffset) >= ((ActiveQuestsMenu)this.menu).data.getActiveQuests().size()) continue;
            this.selectedIndex = index;
            break;
        }
        this.questInformation.setVisible(this.selectedIndex >= 0);
        this.leftPos = this.questInformation.updateScreenPosition(this.width, this.imageWidth);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean isHoveringAbsolute(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (((ActiveQuestsMenu)this.menu).data == null) {
            return;
        }
        HunterQuestData data = ((ActiveQuestsMenu)this.menu).getData();
        this.questInformation.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.selectedIndex >= 0 && this.selectedIndex < data.getActiveQuests().size()) {
            this.questInformation.renderContents(guiGraphics, mouseX, mouseY, partialTick, ((ActiveQuestsMenu)this.menu).getCarried().isEmpty(), data.getActiveQuests().get(this.selectedIndex));
        }
        this.renderQuest(guiGraphics, this.scrollOffset, mouseX, mouseY, data.getQuestOrNull(this.scrollOffset));
        this.renderQuest(guiGraphics, this.scrollOffset + 1, mouseX, mouseY, data.getQuestOrNull(this.scrollOffset + 1));
        this.renderQuest(guiGraphics, this.scrollOffset + 2, mouseX, mouseY, data.getQuestOrNull(this.scrollOffset + 2));
        this.renderQuest(guiGraphics, this.scrollOffset + 3, mouseX, mouseY, data.getQuestOrNull(this.scrollOffset + 3));
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderQuest(GuiGraphics guiGraphics, int index, int mouseX, int mouseY, @Nullable HunterQuest quest) {
        if (quest == null) {
            return;
        }
        int x = this.leftPos + 16;
        int y = this.topPos + 13 + (index - this.scrollOffset) * 25;
        guiGraphics.blitSprite(index == this.selectedIndex ? QUEST_BACKGROUND_SELECTED : QUEST_BACKGROUND_UNSELECTED, x, y, 144, 25);
        guiGraphics.drawString(this.font, quest.getTitle(), x + 2, y + 2, -1);
        Component time = QuestUtil.formatDuration(quest, 1.0f, this.minecraft.level.tickRateManager().tickrate());
        guiGraphics.drawString(this.font, time, x + 2, y + 2 + 9, 0x7F7F7F);
    }
}

