/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.screen;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.SanguisClient;
import com.feliscape.sanguis.client.book.BookChapter;
import com.feliscape.sanguis.client.book.BookEntry;
import com.feliscape.sanguis.client.book.BookLink;
import com.feliscape.sanguis.client.book.GuideBookManager;
import com.feliscape.sanguis.client.book.chapter.ChapterEntry;
import com.feliscape.sanguis.client.book.chapter.LinkChapterEntry;
import com.feliscape.sanguis.client.book.widget.BookWidget;
import com.feliscape.sanguis.content.menu.GuideBookMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuideBookScreen
extends AbstractContainerScreen<GuideBookMenu> {
    public static final int PAGE_SIZE_IN_LINES = 18;
    public static final Component ARROW = Component.literal((String)"\u2192 ");
    public static final float ITEM_SCALE = 0.6667f;
    public static final int INDENT_SIZE = 8;
    private static final ResourceLocation BACKGROUND_LOCATION = Sanguis.location("textures/gui/container/daemonologie.png");
    private static final ResourceLocation INDEX_ART = Sanguis.location("textures/gui/guide_book/index_art.png");
    private static final int TEXT_LINK_HOVER_COLOR = -9992794;
    private static final int TEXT_LINK_COLOR = -12235429;
    private static final int TEXT_LINK_DISABLED_COLOR = -6644575;
    @Nullable
    private BookEntry currentEntry;
    @Nullable
    private BookChapter currentChapter;
    private FlipBackButton flipBackButton;
    private FlipForwardButton flipForwardButton;
    private MoveUpButton moveUpButton;
    private int pageNumber = 0;
    private int hoveredDirection = -1;

    public GuideBookScreen(GuideBookMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 336;
        this.imageHeight = 209;
        super.init();
        this.flipBackButton = (FlipBackButton)this.addRenderableWidget((GuiEventListener)new FlipBackButton(this.leftPos + 9, this.topPos + 191, 21, 12));
        this.flipForwardButton = (FlipForwardButton)this.addRenderableWidget((GuiEventListener)new FlipForwardButton(this.leftPos + 306, this.topPos + 191, 21, 12));
        this.moveUpButton = (MoveUpButton)this.addRenderableWidget((GuiEventListener)new MoveUpButton(this.leftPos + 171, this.topPos + 202, 15, 20));
    }

    public void openEntry(@Nullable BookEntry entry) {
        this.currentEntry = entry;
        if (this.currentEntry != null) {
            this.currentEntry.init(this);
        }
        this.pageNumber = 0;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }

    public void openEntry(@Nullable ResourceLocation location) {
        Sanguis.LOGGER.debug("Going to entry {}", (Object)location);
        this.openEntry(location == null ? null : SanguisClient.reloadListeners().getGuideBookManager().getEntry(location));
    }

    public void openChapter(@Nullable BookChapter entry) {
        this.currentChapter = entry;
        this.pageNumber = 0;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }

    public void openChapter(@Nullable ResourceLocation location) {
        Sanguis.LOGGER.debug("Going to chapter {}", (Object)location);
        if (location == GuideBookManager.ROOT_LOCATION) {
            this.goToIndex();
            return;
        }
        this.openChapter(location == null ? null : SanguisClient.reloadListeners().getGuideBookManager().getChapter(location));
    }

    private void goToIndex() {
        this.currentChapter = null;
        this.currentEntry = null;
        this.pageNumber = 0;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }

    private void flipForwards() {
        if (this.currentEntry == null) {
            return;
        }
        if (this.pageNumber < this.currentEntry.getPageCount() - 1) {
            this.pageNumber += 2;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
    }

    private void flipBack() {
        if (this.pageNumber >= 2) {
            this.pageNumber -= 2;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
    }

    protected void moveUp() {
        if (this.currentEntry != null) {
            if (this.currentEntry.getParent() == BookEntry.EMPTY) {
                this.openChapter(this.currentEntry.getChapter());
            } else {
                this.openEntry(this.currentEntry.getParent());
            }
            this.currentEntry = null;
            this.pageNumber = 0;
        } else if (this.currentChapter != null) {
            this.goToIndex();
            this.pageNumber = 0;
        }
    }

    private boolean isOnIndex() {
        return this.currentChapter == null && this.currentEntry == null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.currentEntry != null && this.currentEntry.mouseClick(this, this.pageNumber, mouseX, mouseY)) {
            return true;
        }
        if (this.hoveredDirection > -1) {
            if (this.currentChapter != null) {
                List<ChapterEntry> entries = this.currentChapter.getEntries();
                if (this.hoveredDirection >= entries.size()) {
                    this.openEntry((ResourceLocation)null);
                } else {
                    ChapterEntry chapterEntry = entries.get(this.hoveredDirection);
                    if (chapterEntry instanceof LinkChapterEntry) {
                        LinkChapterEntry link = (LinkChapterEntry)chapterEntry;
                        this.openEntry(link.getLocation());
                    }
                }
                return true;
            }
            if (this.isOnIndex()) {
                BookChapter chapterToLoad = SanguisClient.reloadListeners().getGuideBookManager().getChapter(this.hoveredDirection);
                if (chapterToLoad != null) {
                    this.openChapter(chapterToLoad);
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        if (this.currentEntry != null) {
            ResourceLocation art = this.currentEntry.getArt();
            boolean hasArt = false;
            if (art != BookEntry.EMPTY) {
                guiGraphics.blit(art, this.leftPos + 35, this.topPos + 22, 0.0f, 0.0f, 114, 159, 114, 159);
                hasArt = true;
            }
            if (this.pageNumber > 0 || !hasArt) {
                this.renderPage(this.currentEntry, guiGraphics, this.leftPos, partialTick, mouseX, mouseY, 0, !hasArt);
            }
            this.renderPage(this.currentEntry, guiGraphics, this.leftPos, partialTick, mouseX, mouseY, 1, !hasArt);
            this.hoveredDirection = -1;
        } else if (this.currentChapter != null) {
            int hover = -1;
            List<ChapterEntry> entries = this.currentChapter.getEntries();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(1.25f, 1.25f, 1.0f);
            guiGraphics.pose().translate((float)(this.leftPos + 24) / 1.25f, (float)(this.topPos + 12) / 1.25f, 0.0f);
            guiGraphics.drawString(this.font, this.currentChapter.getTitle(), 0, 0, 0x3F3F3F, false);
            guiGraphics.pose().popPose();
            int y = this.topPos + 12 + 14;
            for (int i = 0; i < entries.size(); ++i) {
                ChapterEntry entry = entries.get(i);
                if (entry instanceof LinkChapterEntry) {
                    LinkChapterEntry link = (LinkChapterEntry)entry;
                    int[] output = this.renderLink(link, hover, y, i, guiGraphics, partialTick, mouseX, mouseY);
                    hover = output[0];
                    y = output[1];
                    continue;
                }
                int x = this.leftPos + this.getXOffset(Mth.floor((float)((float)i / 18.0f))) + 5;
                y = entry.render(x, y, i, guiGraphics, partialTick, mouseX, mouseY);
            }
            this.hoveredDirection = hover;
        } else {
            this.renderIndex(guiGraphics, partialTick, mouseX, mouseY);
        }
    }

    private void renderIndex(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int y = this.topPos + 18;
        guiGraphics.blit(INDEX_ART, this.leftPos + 35, this.topPos + 22, 0.0f, 0.0f, 114, 159, 114, 159);
        List<BookChapter> chapters = SanguisClient.reloadListeners().getGuideBookManager().getAllChapters();
        int hover = -1;
        for (int i = 0; i < chapters.size(); ++i) {
            int x;
            BookChapter entry = chapters.get(i);
            ItemStack icon = entry.getIcon();
            int startX = x = this.leftPos + this.getXOffset(1) + 5;
            int startY = y;
            guiGraphics.drawString(this.font, ARROW, x, y, 0x3F3F3F, false);
            if (icon.isEmpty()) {
                if (hover == -1 && this.isHoveringAbsolute(startX, y, this.font.width((FormattedText)entry.getTitle()), 7, mouseX, mouseY)) {
                    x += 5;
                    hover = i;
                }
                guiGraphics.drawString(this.font, entry.getTitle(), x + 14, y, 0x3F3F3F, false);
            } else {
                PoseStack poseStack = guiGraphics.pose();
                if (hover == -1 && this.isHoveringAbsolute(x += this.font.width((FormattedText)ARROW) - 3, y, startX - x + this.font.width((FormattedText)entry.getTitle()) + 14 + this.font.width((FormattedText)ARROW), 7, mouseX, mouseY)) {
                    x += 5;
                    hover = i;
                }
                poseStack.pushPose();
                poseStack.scale(0.6667f, 0.6667f, 0.6667f);
                poseStack.translate((float)x / 0.6667f, (float)(y - 2) / 0.6667f, 0.0f);
                guiGraphics.renderItem(icon, 0, 0);
                poseStack.popPose();
                guiGraphics.drawString(this.font, entry.getTitle(), x + 14, y, 0x3F3F3F, false);
            }
            y += 12;
        }
        this.hoveredDirection = hover;
    }

    private int[] renderLink(LinkChapterEntry link, int hover, int y, int i, GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x;
        ItemStack icon = link.getIcon();
        int startX = x = this.leftPos + this.getXOffset(Mth.floor((float)((float)i / 18.0f))) + 5 + link.getIndent() * 8;
        int startY = y;
        if (icon.isEmpty()) {
            MutableComponent component = ARROW.copy().append(link.getTitle());
            guiGraphics.drawString(this.font, (Component)component, x, y, 0x3F3F3F, false);
            y += 10;
        } else {
            guiGraphics.drawString(this.font, ARROW, x, y, 0x3F3F3F, false);
            if (hover == -1 && this.isHoveringAbsolute(x += this.font.width((FormattedText)ARROW) - 3, y, startX - x + this.font.width((FormattedText)link.getTitle()) + 14 + this.font.width((FormattedText)ARROW), 7, mouseX, mouseY)) {
                x += 5;
                hover = i;
            }
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.scale(0.6667f, 0.6667f, 0.6667f);
            poseStack.translate((float)x / 0.6667f, (float)(y - 2) / 0.6667f, 0.0f);
            guiGraphics.renderItem(icon, 0, 0);
            poseStack.popPose();
            guiGraphics.drawString(this.font, link.getTitle(), x += 14, y, 0x3F3F3F, false);
            y += 12;
        }
        return new int[]{hover, y};
    }

    protected boolean isHoveringAbsolute(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    private int getXOffset(int page) {
        return page % 2 == 0 ? 24 : 172;
    }

    private void renderPage(BookEntry entry, GuiGraphics guiGraphics, int xStart, float partialTick, int mouseX, int mouseY, int pageOffset, boolean startOnLeft) {
        int startReadingAt;
        if (pageOffset <= 0 && this.pageNumber <= 0 && !startOnLeft) {
            return;
        }
        int x = xStart + this.getXOffset(this.pageNumber + pageOffset);
        for (BookWidget widget : entry.getWidgets()) {
            if (widget.getDisplayPage() != this.pageNumber + pageOffset) continue;
            widget.render(guiGraphics, x, this.topPos + 18, partialTick);
        }
        for (int i = startReadingAt = (this.pageNumber + pageOffset - (startOnLeft ? 0 : 1)) * 18; i < startReadingAt + 18; ++i) {
            int y = this.topPos + 14 + (i - startReadingAt) * 10;
            if (entry.getEntryText().size() <= i) continue;
            String printLine = entry.getEntryText().get(i);
            guiGraphics.drawString(this.font, printLine, x, y, 0x3F3F3F, false);
            for (BookLink link : entry.getBookLinks()) {
                if (link.getLineNumber() != i) continue;
                int fontWidth = this.font.width(printLine.substring(0, link.getCharacterStartsAt()));
                MutableComponent component = Component.literal((String)link.getDisplayText()).withStyle(ChatFormatting.UNDERLINE);
                guiGraphics.drawString(this.font, (Component)component, fontWidth + x, y, link.isHovered() ? -9992794 : -12235429, false);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.flipForwardButton.active = this.currentEntry != null && this.pageNumber < this.currentEntry.getPageCount() - 1;
        this.flipBackButton.active = this.pageNumber >= 2;
        boolean bl = this.moveUpButton.active = this.currentEntry != null || this.currentChapter != null;
        if (this.currentEntry != null) {
            this.currentEntry.mouseOver(this, this.pageNumber, mouseX, mouseY);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.minecraft.options.keyLeft.getKey().getValue() || keyCode == 263) {
            this.flipBack();
            return true;
        }
        if (keyCode == this.minecraft.options.keyRight.getKey().getValue() || keyCode == 262) {
            this.flipForwards();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public class FlipBackButton
    extends GuideBookButton {
        private static final ResourceLocation BUTTON_HIGHLIGHTED_SPRITE = Sanguis.location("container/guide_book/flip_back_highlighted");
        private static final ResourceLocation BUTTON_SPRITE = Sanguis.location("container/guide_book/flip_back");

        public FlipBackButton(int x, int y, int width, int height) {
            super(x, y, width, height, BUTTON_SPRITE, BUTTON_HIGHLIGHTED_SPRITE, CommonComponents.EMPTY);
        }

        public void onPress() {
            if (!this.isActive()) {
                return;
            }
            GuideBookScreen.this.flipBack();
        }
    }

    public class FlipForwardButton
    extends GuideBookButton {
        private static final ResourceLocation BUTTON_HIGHLIGHTED_SPRITE = Sanguis.location("container/guide_book/flip_forwards_highlighted");
        private static final ResourceLocation BUTTON_SPRITE = Sanguis.location("container/guide_book/flip_forwards");

        public FlipForwardButton(int x, int y, int width, int height) {
            super(x, y, width, height, BUTTON_SPRITE, BUTTON_HIGHLIGHTED_SPRITE, CommonComponents.EMPTY);
        }

        public void onPress() {
            if (!this.isActive()) {
                return;
            }
            GuideBookScreen.this.flipForwards();
        }
    }

    public class MoveUpButton
    extends GuideBookButton {
        private static final ResourceLocation BUTTON_HIGHLIGHTED_SPRITE = Sanguis.location("container/guide_book/move_up_hovered");
        private static final ResourceLocation BUTTON_DISABLED_SPRITE = Sanguis.location("container/guide_book/move_up_disabled");
        private static final ResourceLocation BUTTON_SPRITE = Sanguis.location("container/guide_book/move_up");

        public MoveUpButton(int x, int y, int width, int height) {
            super(x, y, width, height, BUTTON_SPRITE, BUTTON_HIGHLIGHTED_SPRITE, CommonComponents.EMPTY);
        }

        @Override
        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ResourceLocation resourcelocation = !this.isActive() ? BUTTON_DISABLED_SPRITE : (this.isHovered() ? BUTTON_HIGHLIGHTED_SPRITE : BUTTON_SPRITE);
            guiGraphics.blitSprite(resourcelocation, this.getX(), this.getY(), this.width, this.height);
        }

        public void onPress() {
            if (!this.isActive()) {
                return;
            }
            GuideBookScreen.this.moveUp();
        }
    }

    protected static abstract class GuideBookButton
    extends AbstractButton {
        protected ResourceLocation sprite;
        protected ResourceLocation highlightedSprite;

        public GuideBookButton(int x, int y, int width, int height, ResourceLocation sprite, ResourceLocation highlightedSprite, Component message) {
            super(x, y, width, height, message);
            this.sprite = sprite;
            this.highlightedSprite = highlightedSprite;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.isActive()) {
                return;
            }
            ResourceLocation resourcelocation = this.isHovered() ? this.highlightedSprite : this.sprite;
            guiGraphics.blitSprite(resourcelocation, this.getX(), this.getY(), this.width, this.height);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

