/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.client.screen;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.SanguisClient;
import com.feliscape.sanguis.client.screen.ActiveQuestsScreen;
import com.feliscape.sanguis.content.menu.ActiveQuestsMenu;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.networking.payload.ServerboundCancelQuestPayload;
import com.feliscape.sanguis.networking.payload.ServerboundCompleteQuestPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class QuestInformationComponent
implements Renderable,
GuiEventListener,
NarratableEntry {
    protected static final ResourceLocation QUEST_INFORMATION_LOCATION = Sanguis.location("textures/gui/container/quest_information.png");
    private boolean visible;
    private int xOffset;
    private int width;
    private int height;
    private boolean widthTooNarrow;
    protected Minecraft minecraft;
    protected ActiveQuestsScreen screen;
    private boolean focused;
    private CompleteButton completeButton;
    private CancelButton cancelButton;

    public boolean isVisible() {
        return this.visible;
    }

    public void init(int width, int height, Minecraft minecraft, boolean widthTooNarrow, ActiveQuestsScreen screen) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.widthTooNarrow = widthTooNarrow;
        this.visible = false;
        this.screen = screen;
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int x = this.getX();
        int y = this.getY();
        this.completeButton = new CompleteButton(x + 123, y + 142, 14, 14);
        this.cancelButton = new CancelButton(x + 104, y + 142, 14, 14);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            int i = (this.width - 147) / 2 - this.xOffset;
            int j = (this.height - 166) / 2;
            guiGraphics.blit(QUEST_INFORMATION_LOCATION, i, j, 0, 0, 147, 166);
        }
    }

    public void renderContents(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, boolean canRenderTooltip, HunterQuest quest) {
        int x = this.getX() + 10;
        int y = this.getY() + 10;
        guiGraphics.drawString(this.minecraft.font, quest.getTitle(), x, y, -1);
        guiGraphics.drawString(this.minecraft.font, quest.getTypeName(), x, y += 11, -1);
        SanguisClient.reloadListeners().getQuestRenderDispatcher().render(quest, x, y += 13, mouseX, mouseY, canRenderTooltip, guiGraphics);
        this.completeButton.active = quest.isCompleted();
        this.completeButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.cancelButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public int updateScreenPosition(int width, int imageWidth) {
        int i = this.isVisible() && !this.widthTooNarrow ? 177 + (width - imageWidth - 200) / 2 : (width - imageWidth) / 2;
        return i;
    }

    public int getX() {
        return (this.width - 147) / 2 - this.xOffset;
    }

    public int getY() {
        return (this.height - 166) / 2;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (this.completeButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.cancelButton.mouseClicked(mouseX, mouseY, button);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initVisuals();
        }
        this.visible = visible;
    }

    public class CompleteButton
    extends QuestButton {
        private static final ResourceLocation ICON = Sanguis.location("container/quests/complete");

        public CompleteButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.translatable((String)"container.sanguis.active_quests.complete"));
        }

        public CompleteButton(int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message);
            this.setTooltip(Tooltip.create((Component)message));
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundCompleteQuestPayload(((ActiveQuestsMenu)QuestInformationComponent.this.screen.getMenu()).containerId, QuestInformationComponent.this.screen.selectedIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
            QuestInformationComponent.this.screen.selectedIndex = -1;
        }

        @Override
        protected void renderIcon(GuiGraphics guiGraphics) {
            guiGraphics.blitSprite(ICON, this.getX(), this.getY(), 14, 14);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }

    public class CancelButton
    extends QuestButton {
        private static final ResourceLocation ICON = Sanguis.location("container/quests/cancel");

        public CancelButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.translatable((String)"container.sanguis.active_quests.cancel"));
        }

        public CancelButton(int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message);
            this.setTooltip(Tooltip.create((Component)message));
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundCancelQuestPayload(((ActiveQuestsMenu)QuestInformationComponent.this.screen.getMenu()).containerId, QuestInformationComponent.this.screen.selectedIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        protected void renderIcon(GuiGraphics guiGraphics) {
            guiGraphics.blitSprite(ICON, this.getX(), this.getY(), 14, 14);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }

    public static abstract class QuestButton
    extends AbstractButton {
        private static final ResourceLocation BUTTON_DISABLED_SPRITE = Sanguis.location("container/quests/button_disabled");
        private static final ResourceLocation BUTTON_HIGHLIGHTED_SPRITE = Sanguis.location("container/quests/button_highlighted");
        private static final ResourceLocation BUTTON_SPRITE = Sanguis.location("container/quests/button");

        public QuestButton(int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ResourceLocation resourcelocation = !this.active ? BUTTON_DISABLED_SPRITE : (this.isHoveredOrFocused() ? BUTTON_HIGHLIGHTED_SPRITE : BUTTON_SPRITE);
            guiGraphics.blitSprite(resourcelocation, this.getX(), this.getY(), this.width, this.height);
            this.renderIcon(guiGraphics);
        }

        protected abstract void renderIcon(GuiGraphics var1);
    }
}

