/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.attachment;

import com.feliscape.sanguis.content.attachment.DataAttachment;
import com.feliscape.sanguis.data.damage.SanguisDamageSources;
import com.feliscape.sanguis.data.map.EntityBloodContent;
import com.feliscape.sanguis.registry.SanguisDataAttachmentTypes;
import com.feliscape.sanguis.registry.SanguisDataMapTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;

public class EntityBloodData
extends DataAttachment {
    private LivingEntity holder;
    int restoration;
    int remainingBlood = 1;
    float saturation;
    int maxBlood = 1;
    int frozenTicks = 0;

    public EntityBloodData() {
    }

    @Override
    protected void save(CompoundTag tag) {
        tag.putInt("remainingBlood", this.getRemainingBlood());
        tag.putFloat("saturation", this.getSaturation());
        tag.putInt("maxBlood", this.getMaxBlood());
        tag.putInt("frozenTicks", this.getFrozenTicks());
        tag.putInt("restoration", this.getRestoration());
    }

    @Override
    protected void load(CompoundTag tag) {
        this.remainingBlood = tag.getInt("remainingBlood");
        this.saturation = tag.getInt("saturation");
        this.maxBlood = tag.getInt("maxBlood");
        this.frozenTicks = tag.getInt("frozenTicks");
        this.restoration = tag.getInt("restoration");
    }

    public EntityBloodData(int remainingBlood, float saturation, int maxBlood) {
        this.remainingBlood = remainingBlood;
        this.saturation = saturation;
        this.maxBlood = maxBlood;
    }

    public EntityBloodData(int remainingBlood, float saturation, int maxBlood, int frozenTicks) {
        this.remainingBlood = remainingBlood;
        this.saturation = saturation;
        this.maxBlood = maxBlood;
        this.frozenTicks = frozenTicks;
    }

    public int getRemainingBlood() {
        return this.remainingBlood;
    }

    public int getRestoration() {
        return this.restoration;
    }

    private void setRemainingBlood(int remainingBlood) {
        this.remainingBlood = remainingBlood;
    }

    public int getMaxBlood() {
        return this.maxBlood;
    }

    private void setMaxBlood(int maxBlood) {
        this.maxBlood = maxBlood;
    }

    public int getFrozenTicks() {
        return this.frozenTicks;
    }

    private void setFrozenTicks(int frozenTicks) {
        this.frozenTicks = frozenTicks;
    }

    public float getSaturation() {
        return this.saturation;
    }

    private void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public boolean isFrozen() {
        return this.getFrozenTicks() > 0;
    }

    public void tick() {
        if (this.frozenTicks > 0) {
            --this.frozenTicks;
            this.holder.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 2));
            LivingEntity livingEntity = this.holder;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                if (mob.getNavigation().isInProgress()) {
                    mob.getNavigation().stop();
                }
                this.holder.setXRot(20.0f);
            }
        }
        if (this.remainingBlood > 0 && this.remainingBlood < this.maxBlood) {
            ++this.restoration;
            if (this.restoration > 12000) {
                this.restoration -= 12000;
                ++this.remainingBlood;
            }
        }
    }

    public int drain() {
        if (this.remainingBlood == 0) {
            return 0;
        }
        if (!this.holder.hurt(SanguisDamageSources.draining(this.holder.level(), (Entity)this.holder), this.remainingBlood - 1 <= 0 ? this.holder.getMaxHealth() * 10.0f : this.holder.getMaxHealth() / ((float)this.maxBlood + 1.0f))) {
            return 0;
        }
        --this.remainingBlood;
        this.restoration = -500;
        this.holder.syncData(EntityBloodData.type());
        this.frozenTicks = 20;
        return 1;
    }

    public static EntityBloodData getInstance(IAttachmentHolder iAttachmentHolder) {
        if (!(iAttachmentHolder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to attach EntityBloodData to non-LivingEntity");
        }
        LivingEntity entity = (LivingEntity)iAttachmentHolder;
        EntityBloodContent bloodContent = (EntityBloodContent)entity.getType().builtInRegistryHolder().getData(SanguisDataMapTypes.ENTITY_BLOOD);
        if (bloodContent == null) {
            throw new IllegalArgumentException("Entity %s does not have blood".formatted(entity.getDisplayName().getString()));
        }
        EntityBloodData data = new EntityBloodData(bloodContent.amount(), bloodContent.saturationModifier(), bloodContent.amount());
        data.setHolder(entity);
        return data;
    }

    protected void setHolder(IAttachmentHolder holder) {
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to set BloodEntityData holder to non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)holder;
        EntityBloodContent bloodContent = (EntityBloodContent)living.getType().builtInRegistryHolder().getData(SanguisDataMapTypes.ENTITY_BLOOD);
        if (bloodContent == null) {
            throw new IllegalArgumentException("Entity %s does not have blood".formatted(living.getDisplayName().getString()));
        }
        this.holder = living;
    }

    protected void setHolder(LivingEntity living) {
        EntityBloodContent bloodContent = (EntityBloodContent)living.getType().builtInRegistryHolder().getData(SanguisDataMapTypes.ENTITY_BLOOD);
        if (bloodContent == null) {
            throw new IllegalArgumentException("Entity %s does not have blood".formatted(living.getDisplayName().getString()));
        }
        this.holder = living;
    }

    public static boolean canHaveBlood(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        EntityBloodContent bloodContent = (EntityBloodContent)living.getType().builtInRegistryHolder().getData(SanguisDataMapTypes.ENTITY_BLOOD);
        return bloodContent != null;
    }

    public static AttachmentType<EntityBloodData> type() {
        return SanguisDataAttachmentTypes.ENTITY_BLOOD.get();
    }

    public static class SyncHandler
    implements AttachmentSyncHandler<EntityBloodData> {
        public void write(RegistryFriendlyByteBuf buf, EntityBloodData attachment, boolean initialSync) {
            buf.writeInt(attachment.getRemainingBlood());
            buf.writeFloat(attachment.getSaturation());
            buf.writeInt(attachment.getMaxBlood());
            buf.writeInt(attachment.getFrozenTicks());
        }

        @Nullable
        public EntityBloodData read(IAttachmentHolder holder, RegistryFriendlyByteBuf buf, @Nullable EntityBloodData previousValue) {
            if (previousValue == null) {
                EntityBloodData newData = new EntityBloodData(buf.readInt(), buf.readInt(), buf.readInt());
                newData.setHolder(holder);
                return newData;
            }
            previousValue.setHolder(holder);
            previousValue.setRemainingBlood(buf.readInt());
            previousValue.setSaturation(buf.readFloat());
            previousValue.setMaxBlood(buf.readInt());
            previousValue.setFrozenTicks(buf.readInt());
            return previousValue;
        }
    }
}

