/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.attachment;

import com.feliscape.sanguis.content.attachment.DataAttachment;
import com.feliscape.sanguis.content.attachment.HunterQuestData;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.registry.SanguisCriteriaTriggers;
import com.feliscape.sanguis.registry.SanguisDataAttachmentTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;

public class HunterData
extends DataAttachment {
    private LivingEntity holder;
    private boolean hasInjection;
    private HunterQuestData quests = new HunterQuestData();
    public static final StreamCodec<RegistryFriendlyByteBuf, HunterData> FULL_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, HunterData::hasInjection, HunterQuestData.STREAM_CODEC, HunterData::getQuests, HunterData::new);

    public HunterData() {
    }

    public HunterData(boolean hasInjection, HunterQuestData questData) {
        this.hasInjection = hasInjection;
        this.quests = questData;
    }

    @Override
    protected void save(CompoundTag tag) {
        tag.putBoolean("hasInjection", this.hasInjection);
        tag.put("questData", (Tag)HunterQuestData.save(this.quests));
    }

    @Override
    protected void load(CompoundTag tag) {
        this.hasInjection = tag.getBoolean("hasInjection");
        this.quests = HunterQuestData.load(tag.getCompound("questData"));
        this.quests.setPlayer((Entity)this.holder);
    }

    public void tick() {
        if (this.holder instanceof Player) {
            this.quests.tick();
        }
    }

    public void removeGarlic() {
        this.hasInjection = false;
        this.quests.getActiveQuests().clear();
        this.holder.syncData(HunterData.type());
    }

    public void injectGarlic() {
        this.hasInjection = true;
        LivingEntity livingEntity = this.holder;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            SanguisCriteriaTriggers.HUNTER_INJECT.get().trigger(player);
        }
        this.holder.syncData(HunterData.type());
    }

    public boolean hasInjection() {
        return this.hasInjection;
    }

    public HunterQuestData getQuests() {
        return this.quests;
    }

    public void addQuest(HunterQuest quest) {
        this.quests.add(quest);
        this.holder.syncData(HunterData.type());
    }

    protected void setHolder(IAttachmentHolder holder) {
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to set HunterData holder to non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)holder;
        this.holder = living;
        if (living instanceof Player) {
            Player player = (Player)living;
            this.quests.setPlayer(player);
        } else {
            this.quests.setPlayer((Player)null);
        }
    }

    protected void setHolder(LivingEntity holder) {
        this.holder = holder;
        if (holder instanceof Player) {
            Player player = (Player)holder;
            this.quests.setPlayer(player);
        } else {
            this.quests.setPlayer((Player)null);
        }
    }

    public static HunterData copyDeathPersistent(HunterData oldData, IAttachmentHolder holder, HolderLookup.Provider provider) {
        HunterData newData = new HunterData(oldData.hasInjection, oldData.quests);
        newData.setHolder(holder);
        return newData;
    }

    public static HunterData getInstance(IAttachmentHolder iAttachmentHolder) {
        if (!(iAttachmentHolder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to attach HunterData to non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)iAttachmentHolder;
        HunterData data = new HunterData();
        data.setHolder(living);
        return data;
    }

    public static AttachmentType<HunterData> type() {
        return SanguisDataAttachmentTypes.HUNTER.get();
    }

    public HunterData update(IAttachmentHolder holder, RegistryFriendlyByteBuf buffer) {
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to read HunterData for non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)holder;
        this.hasInjection = buffer.readBoolean();
        this.quests = (HunterQuestData)HunterQuestData.STREAM_CODEC.decode((Object)buffer);
        this.setHolder(living);
        return this;
    }

    public static class SyncHandler
    implements AttachmentSyncHandler<HunterData> {
        public void write(RegistryFriendlyByteBuf buf, HunterData attachment, boolean initialSync) {
            if (initialSync) {
                FULL_STREAM_CODEC.encode((Object)buf, (Object)attachment);
            } else {
                buf.writeBoolean(attachment.hasInjection);
                HunterQuestData.STREAM_CODEC.encode((Object)buf, (Object)attachment.quests);
            }
        }

        @Nullable
        public HunterData read(IAttachmentHolder holder, RegistryFriendlyByteBuf buf, @Nullable HunterData previousValue) {
            if (previousValue == null) {
                HunterData newData = (HunterData)FULL_STREAM_CODEC.decode((Object)buf);
                newData.setHolder(holder);
                return newData;
            }
            return previousValue.update(holder, buf);
        }
    }
}

