/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.attachment;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HunterQuestData {
    private final List<HunterQuest> activeQuests;
    @Nullable
    protected Player player;
    public static final StreamCodec<RegistryFriendlyByteBuf, HunterQuestData> STREAM_CODEC = StreamCodec.composite((StreamCodec)HunterQuest.TYPED_STREAM_CODEC.apply(ByteBufCodecs.list()), HunterQuestData::getActiveQuests, HunterQuestData::new);

    public HunterQuestData() {
        this.activeQuests = new ArrayList<HunterQuest>();
    }

    public HunterQuestData(List<HunterQuest> quests) {
        this.activeQuests = quests;
    }

    public void add(HunterQuest hunterQuest) {
        this.activeQuests.add(hunterQuest);
    }

    public void complete(int index) {
        if (this.player == null) {
            return;
        }
        HunterQuest quest = this.getQuest(index);
        quest.complete(this.player);
        this.activeQuests.remove(index);
        this.player.syncData(HunterData.type());
    }

    public void cancel(int index) {
        if (this.player == null) {
            return;
        }
        this.activeQuests.remove(index);
        this.player.syncData(HunterData.type());
    }

    public void tick() {
        if (this.player == null) {
            return;
        }
        Iterator<HunterQuest> iterator = this.activeQuests.iterator();
        try {
            while (iterator.hasNext()) {
                HunterQuest quest = iterator.next();
                quest.tick(this.player);
                if (quest.getDuration() != 0) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.player.syncData(HunterData.type());
    }

    public List<HunterQuest> getActiveQuests() {
        return this.activeQuests;
    }

    public HunterQuest getQuest(int index) {
        return this.activeQuests.get(index);
    }

    public static CompoundTag save(HunterQuestData data) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (HunterQuest quest : data.activeQuests) {
            list.add((Object)((Tag)HunterQuest.TYPED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)quest).getOrThrow()));
        }
        compound.put("quests", (Tag)list);
        return compound;
    }

    public static HunterQuestData load(CompoundTag tag) {
        ArrayList<HunterQuest> quests = new ArrayList<HunterQuest>();
        ListTag list = tag.getList("quests", 10);
        for (int i = 0; i < list.size(); ++i) {
            quests.add((HunterQuest)((Pair)HunterQuest.TYPED_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)list.get(i)).getOrThrow()).getFirst());
        }
        return new HunterQuestData(quests);
    }

    @Nullable
    public HunterQuest getQuestOrNull(int index) {
        if (index < 0 || index >= this.activeQuests.size()) {
            return null;
        }
        return this.activeQuests.get(index);
    }

    public void setPlayer(@Nullable Player player) {
        this.player = player;
    }

    public void setPlayer(@Nullable Entity entity) {
        if (entity instanceof Player) {
            Player player1 = (Player)entity;
            this.setPlayer(player1);
        } else {
            this.player = null;
        }
    }
}

