/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.attachment;

import com.feliscape.sanguis.content.attachment.EntityBloodData;
import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.data.damage.SanguisDamageSources;
import com.feliscape.sanguis.registry.SanguisDataComponents;
import com.feliscape.sanguis.registry.SanguisSoundEvents;
import com.feliscape.sanguis.util.VampireUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;

public class VampireBloodData {
    private int drinkDelay = 0;
    private int blood = this.maxBlood();
    private float exhaustion;
    private float saturation;
    private int tickTimer;
    public static final StreamCodec<RegistryFriendlyByteBuf, VampireBloodData> FULL_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, VampireBloodData::getDrinkDelay, (StreamCodec)ByteBufCodecs.INT, VampireBloodData::getBlood, (StreamCodec)ByteBufCodecs.FLOAT, VampireBloodData::getExhaustion, (StreamCodec)ByteBufCodecs.FLOAT, VampireBloodData::getSaturation, (StreamCodec)ByteBufCodecs.INT, data -> data.tickTimer, VampireBloodData::new);

    public VampireBloodData() {
    }

    public VampireBloodData(int drinkDelay, int blood, float exhaustion, float saturation, int tickTimer) {
        this.drinkDelay = drinkDelay;
        this.blood = blood;
        this.exhaustion = exhaustion;
        this.saturation = saturation;
        this.tickTimer = tickTimer;
    }

    public void drink(LivingEntity holder, LivingEntity target) {
        EntityBloodData data;
        int drainAmount;
        if (this.drinkDelay > 0 || !target.isAlive()) {
            return;
        }
        if (VampireUtil.hasFoulBlood((Entity)target)) {
            target.hurt(SanguisDamageSources.draining(target.level(), (Entity)target), 2.0f);
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
            holder.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 2));
        } else if (target instanceof Player) {
            Player player = (Player)target;
            if (!VampireUtil.isVampire((Entity)player) && target.hurt(SanguisDamageSources.draining(target.level(), (Entity)target), 2.0f)) {
                this.increaseBlood(1, holder, true);
                this.saturation = Math.min(this.saturation + 1.0f, (float)this.blood);
                holder.syncData(VampireData.type());
            }
        } else if (EntityBloodData.canHaveBlood((Entity)target) && (drainAmount = (data = (EntityBloodData)target.getData(EntityBloodData.type())).drain()) > 0) {
            this.increaseBlood(drainAmount, holder, true);
            this.saturation = Math.min(this.saturation + data.getSaturation(), (float)this.blood);
            holder.syncData(VampireData.type());
        }
        float f = holder.getRandom().nextFloat() * 0.2f + 0.9f;
        this.playSoundServer(holder, SanguisSoundEvents.VAMPIRE_DRINK.get(), 1.0f, f);
        this.drinkDelay = 14;
    }

    private void playSoundServer(LivingEntity entity, SoundEvent soundEvent) {
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, entity.getSoundSource(), 1.0f, 1.0f);
    }

    private void playSoundServer(LivingEntity entity, SoundEvent soundEvent, float volume, float pitch) {
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, entity.getSoundSource(), volume, pitch);
    }

    public void drink(LivingEntity holder, int amount, float saturation) {
        this.increaseBlood(amount);
        this.saturation = Math.min(this.saturation + saturation, (float)this.blood);
        holder.syncData(VampireData.type());
    }

    public void tick(Player player) {
        if (this.drinkDelay > 0) {
            --this.drinkDelay;
        }
        if (!player.getAbilities().invulnerable) {
            Difficulty difficulty = player.level().getDifficulty();
            if (this.exhaustion > 4.0f) {
                this.exhaustion -= 4.0f;
                if (this.saturation > 0.0f) {
                    this.saturation = Math.max(this.saturation - 1.0f, 0.0f);
                } else if (difficulty != Difficulty.PEACEFUL) {
                    this.blood = Math.max(this.blood - 1, 0);
                }
                player.syncData(VampireData.type());
            }
            this.addExhaustion(this.getTickExhaustion(player));
            boolean canRegenerate = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION);
            if (canRegenerate && this.saturation > 0.0f && player.isHurt() && this.blood >= 20) {
                ++this.tickTimer;
                if (this.tickTimer >= 10) {
                    float f = Math.min(this.saturation, 6.0f);
                    player.heal(f / 6.0f);
                    this.addExhaustion(f);
                    this.tickTimer = 0;
                }
            } else if (canRegenerate && this.blood >= 18 && player.isHurt()) {
                ++this.tickTimer;
                if (this.tickTimer >= 80) {
                    player.heal(1.0f);
                    this.addExhaustion(6.0f);
                    this.tickTimer = 0;
                }
            } else if (this.blood <= 0) {
                ++this.tickTimer;
                if (this.tickTimer >= 80) {
                    if (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                        player.hurt(player.damageSources().starve(), 1.0f);
                    }
                    this.tickTimer = 0;
                }
            } else {
                this.tickTimer = 0;
            }
            player.getFoodData().setFoodLevel(this.getBlood());
        }
    }

    public int maxBlood() {
        return 20;
    }

    public float getTickExhaustion(Player player) {
        return VampireUtil.isBat((Entity)player) ? this.getBatExhaustion(player) : 0.004f;
    }

    public float getBatExhaustion(Player player) {
        if (player.isSprinting()) {
            return 0.009f;
        }
        return 0.006f;
    }

    public void addExhaustion(float amount) {
        this.exhaustion = Math.min(this.exhaustion + amount, 40.0f);
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public int consumeBlood(int amount, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().invulnerable) {
                return this.blood;
            }
        }
        this.blood = Math.max(this.blood - amount, 0);
        return this.blood;
    }

    public int decreaseBlood(int amount) {
        this.blood = Math.max(this.blood - amount, 0);
        return this.blood;
    }

    public int increaseBlood(int amount) {
        this.blood = Math.min(this.blood + amount, this.maxBlood());
        return this.blood;
    }

    public int increaseBlood(int amount, LivingEntity entity, boolean addExcessToBottles) {
        int excess;
        if (amount == 0) {
            return this.blood;
        }
        if (addExcessToBottles && (excess = this.blood + amount - this.maxBlood()) > 0) {
            this.addToBottles(entity, excess);
        }
        this.blood = Math.min(this.blood + amount, this.maxBlood());
        return this.blood;
    }

    private void addToBottles(LivingEntity entity, int excess) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (excess > 0) {
                ItemStack mainHand;
                ItemStack offhand = entity.getOffhandItem();
                if (offhand.has(SanguisDataComponents.MAX_BLOOD)) {
                    int blood = (Integer)offhand.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
                    int maxBlood = (Integer)offhand.getOrDefault(SanguisDataComponents.MAX_BLOOD, (Object)0);
                    if (maxBlood <= 0) {
                        return;
                    }
                    int amount = Math.min(maxBlood - blood, excess);
                    offhand.set(SanguisDataComponents.BLOOD, (Object)(blood + amount));
                    if ((excess -= amount) <= 0) {
                        return;
                    }
                }
                if ((mainHand = entity.getMainHandItem()).has(SanguisDataComponents.MAX_BLOOD)) {
                    int blood = (Integer)mainHand.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
                    int maxBlood = (Integer)mainHand.getOrDefault(SanguisDataComponents.MAX_BLOOD, (Object)0);
                    if (maxBlood <= 0) {
                        return;
                    }
                    int amount = Math.min(maxBlood - blood, excess);
                    mainHand.set(SanguisDataComponents.BLOOD, (Object)(blood + amount));
                    if ((excess -= amount) <= 0) {
                        return;
                    }
                }
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack itemStack = player.getInventory().getItem(i);
                    if (!itemStack.has(SanguisDataComponents.MAX_BLOOD)) continue;
                    int blood = (Integer)itemStack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
                    int maxBlood = (Integer)itemStack.getOrDefault(SanguisDataComponents.MAX_BLOOD, (Object)0);
                    if (maxBlood <= 0) {
                        return;
                    }
                    int amount = Math.min(maxBlood - blood, excess);
                    itemStack.set(SanguisDataComponents.BLOOD, (Object)(blood + amount));
                    if ((excess -= amount) > 0) continue;
                    return;
                }
                player.getInventory().setChanged();
            }
        }
    }

    public int getBlood() {
        return this.blood;
    }

    public int getDrinkDelay() {
        return this.drinkDelay;
    }

    public void setDrinkDelay(int drinkDelay) {
        this.drinkDelay = drinkDelay;
    }

    public void setBlood(int blood) {
        this.blood = blood;
    }

    public void setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
    }

    public static CompoundTag save(CompoundTag tag, VampireBloodData data) {
        tag.putInt("blood", data.blood);
        tag.putFloat("exhaustion", data.exhaustion);
        tag.putFloat("saturation", data.saturation);
        tag.putInt("foodTickTimer", data.tickTimer);
        return tag;
    }

    public static VampireBloodData load(CompoundTag tag) {
        VampireBloodData data = new VampireBloodData();
        data.blood = tag.getInt("blood");
        data.exhaustion = tag.getFloat("exhaustion");
        data.saturation = tag.getFloat("saturation");
        data.tickTimer = tag.getInt("foodTickTimer");
        return data;
    }

    public void update(RegistryFriendlyByteBuf byteBuf) {
        this.drinkDelay = byteBuf.readInt();
        this.blood = byteBuf.readInt();
        this.exhaustion = byteBuf.readFloat();
        this.saturation = byteBuf.readFloat();
        this.tickTimer = byteBuf.readInt();
    }
}

