/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.attachment;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.content.attachment.DataAttachment;
import com.feliscape.sanguis.content.attachment.VampireBloodData;
import com.feliscape.sanguis.registry.SanguisCriteriaTriggers;
import com.feliscape.sanguis.registry.SanguisDataAttachmentTypes;
import com.feliscape.sanguis.registry.SanguisSoundEvents;
import com.feliscape.sanguis.registry.SanguisTags;
import com.feliscape.sanguis.util.VampireUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.Nullable;

public class VampireData
extends DataAttachment {
    private LivingEntity holder;
    private int infectionTime = -1;
    private int startInfectionTime = -1;
    private boolean isVampire;
    private boolean wasBat;
    private boolean isBat;
    private float storedHumanoidHealth;
    @Nullable
    private Bat bat;
    private static final Multimap<Holder<Attribute>, AttributeModifier> BAT_ATTRIBUTES = ImmutableMultimap.of((Object)NeoForgeMod.CREATIVE_FLIGHT, (Object)new AttributeModifier(Sanguis.location("vampire.bat_form.flight"), 1.0, AttributeModifier.Operation.ADD_VALUE), (Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(Sanguis.location("vampire.bat_form.damage"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), (Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(Sanguis.location("vampire.bat_form.health"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    private int tier;
    private VampireBloodData bloodData = new VampireBloodData();
    public static final StreamCodec<RegistryFriendlyByteBuf, VampireData> FULL_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, VampireData::getInfectionTime, (StreamCodec)ByteBufCodecs.INT, VampireData::getStartInfectionTime, (StreamCodec)ByteBufCodecs.BOOL, VampireData::isVampire, (StreamCodec)ByteBufCodecs.BOOL, VampireData::isBat, (StreamCodec)ByteBufCodecs.VAR_INT, VampireData::getTier, VampireBloodData.FULL_STREAM_CODEC, VampireData::getBloodData, VampireData::new);

    public VampireData(LivingEntity holder) {
        this.setHolder(holder);
        if (holder.level().isClientSide() && this.bat == null) {
            this.bat = (Bat)EntityType.BAT.create(holder.level());
        }
    }

    public VampireData() {
    }

    public VampireData(boolean isVampire, int tier) {
        this.isVampire = isVampire;
        this.infectionTime = isVampire ? 0 : -1;
        this.tier = tier;
    }

    public VampireData(int infectionTime, boolean isVampire, int tier) {
        this.infectionTime = infectionTime;
        this.isVampire = isVampire;
        this.tier = tier;
    }

    public VampireData(int infectionTime, int startInfectionTime, boolean isVampire, boolean isBat, int tier, VampireBloodData bloodData) {
        this.infectionTime = infectionTime;
        this.startInfectionTime = startInfectionTime;
        this.isVampire = isVampire;
        this.isBat = isBat;
        this.tier = tier;
        this.bloodData = bloodData;
    }

    @Override
    protected void save(CompoundTag tag) {
        tag.putInt("infectionTime", this.infectionTime);
        tag.putInt("startInfectionTime", this.startInfectionTime);
        tag.putBoolean("isVampire", this.isVampire);
        tag.putBoolean("isBat", this.isBat);
        tag.putInt("tier", this.tier);
        tag.putFloat("storedHumanoidHealth", this.storedHumanoidHealth);
        tag.put("bloodData", (Tag)VampireBloodData.save(new CompoundTag(), this.bloodData));
    }

    @Override
    protected void load(CompoundTag tag) {
        this.infectionTime = tag.getInt("infectionTime");
        this.startInfectionTime = tag.getInt("startInfectionTime");
        this.isVampire = tag.getBoolean("isVampire");
        this.isBat = tag.getBoolean("isBat");
        this.tier = tag.getInt("tier");
        this.storedHumanoidHealth = tag.getFloat("storedHumanoidHealth");
        this.bloodData = VampireBloodData.load(tag.getCompound("bloodData"));
    }

    public void toggleBatForm() {
        if (!this.canTransform()) {
            return;
        }
        this.bloodData.addExhaustion(6.0f);
        this.isBat = !this.isBat;
        float health = this.holder.getHealth();
        this.updateBatAttributes();
        this.playSoundServer(this.isBat() ? SanguisSoundEvents.BAT_TRANSFORM.get() : SanguisSoundEvents.VAMPIRE_TRANSFORM.get());
        this.holder.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20));
        if (this.isBat) {
            LivingEntity livingEntity = this.holder;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                SanguisCriteriaTriggers.TRANSFORM_TO_BAT.get().trigger(serverPlayer);
            }
            if (!this.holder.level().isClientSide()) {
                this.storedHumanoidHealth = Math.max(0.0f, health - this.holder.getMaxHealth());
            }
        } else if (!this.holder.level().isClientSide() && this.storedHumanoidHealth > 0.0f) {
            this.holder.heal(this.storedHumanoidHealth);
            this.storedHumanoidHealth = 0.0f;
        }
        this.holder.syncData(VampireData.type());
        this.holder.refreshDimensions();
    }

    public void disableBatForm() {
        if (!this.isBat) {
            return;
        }
        this.isBat = false;
        this.updateBatAttributes();
        this.playSoundServer(SanguisSoundEvents.VAMPIRE_TRANSFORM.get());
        this.holder.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20));
        this.holder.syncData(VampireData.type());
        this.holder.refreshDimensions();
    }

    private void updateBatAttributes() {
        if (this.isBat()) {
            this.holder.getAttributes().addTransientAttributeModifiers(BAT_ATTRIBUTES);
        } else {
            this.holder.getAttributes().removeAttributeModifiers(BAT_ATTRIBUTES);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canTransform() {
        LivingEntity livingEntity;
        if (!this.isBat && this.tier == 0) {
            return false;
        }
        if (!VampireUtil.shouldBurnInSunlight(this.holder) && this.holder.getHealth() > 2.0f) {
            if (this.bloodData.getBlood() >= (this.isBat ? 4 : 6)) return true;
        }
        if (!((livingEntity = this.holder) instanceof Player)) return false;
        Player player = (Player)livingEntity;
        if (!player.getAbilities().invulnerable) return false;
        return true;
    }

    public Bat getBat() {
        return this.bat;
    }

    public void clientTick() {
        if (!this.isVampire || this.holder == null || !this.holder.level().isClientSide()) {
            return;
        }
        if (this.bat != null) {
            this.bat.tick();
            ++this.bat.tickCount;
            this.setBatRotation(false);
        }
    }

    public void setBatRotation(boolean includeX) {
        if (this.bat == null) {
            return;
        }
        this.bat.setYHeadRot(this.holder.getYHeadRot());
        this.bat.setYRot(this.holder.getYRot());
        this.bat.setYBodyRot(this.holder.getYRot());
        this.bat.setXRot(includeX ? this.holder.getXRot() : 0.0f);
    }

    public void tick() {
        if (this.infectionTime > 0) {
            --this.infectionTime;
            this.checkVampireStatus();
        }
        if (this.wasBat != this.isBat) {
            this.holder.refreshDimensions();
        }
        if (this.isVampire) {
            Player player;
            LivingEntity livingEntity;
            if (!this.holder.level().isClientSide()) {
                if (this.holder.tickCount % 5 == 0 && VampireUtil.shouldBurnInSunlight(this.holder) && this.canBurn(this.holder)) {
                    this.holder.igniteForSeconds(2.0f);
                }
                if ((livingEntity = this.holder) instanceof Player) {
                    BlockPos blockPos;
                    player = (Player)livingEntity;
                    this.bloodData.tick(player);
                    if (this.holder.tickCount % 20 == 0 && BlockPos.findClosestMatch((BlockPos)(blockPos = this.holder.blockPosition()), (int)4, (int)4, pos -> this.holder.level().getBlockState(pos).is(SanguisTags.Blocks.VAMPIRE_REPELLENTS)).isPresent()) {
                        this.holder.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60, 2, true, true));
                        this.holder.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 0, true, true));
                    }
                }
            }
            if (this.isBat() && (livingEntity = this.holder) instanceof Player) {
                player = (Player)livingEntity;
                if (this.bloodData.getBlood() < 4 && !player.getAbilities().invulnerable) {
                    this.disableBatForm();
                } else {
                    player.getAbilities().flying = true;
                }
            }
        }
        this.wasBat = this.isBat;
    }

    private boolean canBurn(LivingEntity entity) {
        return !entity.fireImmune() && !entity.isInvulnerableTo(entity.damageSources().onFire());
    }

    private boolean inSunlight(LivingEntity entity) {
        Level level = entity.level();
        if (level.isClientSide()) {
            return level.canSeeSky(entity.blockPosition()) && (level.getDayTime() < 13000L || level.getDayTime() > 23500L);
        }
        return level.canSeeSky(entity.blockPosition()) && level.isDay();
    }

    private void checkVampireStatus() {
        boolean wasVampire = this.isVampire;
        if (this.infectionTime == 0) {
            this.isVampire = true;
            if (!wasVampire) {
                this.transformToVampire();
            }
        } else if (this.infectionTime < 0) {
            this.isVampire = false;
            if (wasVampire) {
                this.revertFromVampire();
            }
        }
        if (wasVampire && !this.isVampire) {
            this.disableBatForm();
        }
    }

    private void transformToVampire() {
        this.disableBatForm();
        this.holder.refreshDimensions();
        this.bloodData.setBlood(this.bloodData.maxBlood());
        this.bloodData.setDrinkDelay(0);
        this.bloodData.setExhaustion(0.0f);
        this.holder.playSound(SanguisSoundEvents.VAMPIRE_TRANSFORM.get());
        LivingEntity livingEntity = this.holder;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            SanguisCriteriaTriggers.VAMPIRE_TRANSFORMATION.get().trigger(serverPlayer);
        }
    }

    private void playSoundServer(SoundEvent soundEvent) {
        this.holder.level().playSound(null, this.holder.getX(), this.holder.getY(), this.holder.getZ(), soundEvent, this.holder.getSoundSource(), 1.0f, 1.0f);
    }

    private void playSoundServer(SoundEvent soundEvent, float volume, float pitch) {
        this.holder.level().playSound(null, this.holder.getX(), this.holder.getY(), this.holder.getZ(), soundEvent, this.holder.getSoundSource(), volume, pitch);
    }

    private void revertFromVampire() {
        this.disableBatForm();
        this.holder.refreshDimensions();
        this.tier = 0;
        LivingEntity livingEntity = this.holder;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getFoodData().setFoodLevel(2);
        }
        if ((livingEntity = this.holder) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            SanguisCriteriaTriggers.VAMPIRE_CURE.get().trigger(serverPlayer);
        }
    }

    public int getInfectionTime() {
        return this.infectionTime;
    }

    public int getStartInfectionTime() {
        return this.startInfectionTime;
    }

    public boolean isVampire() {
        return this.isVampire && this.infectionTime >= 0;
    }

    public boolean isBat() {
        return this.isVampire && this.isBat;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean canUpgrade() {
        return this.tier == 0;
    }

    public void upgradeTier() {
        ++this.tier;
    }

    public boolean cure() {
        if (!this.isVampire && !this.isInfected()) {
            return false;
        }
        this.infectionTime = -1;
        this.checkVampireStatus();
        return true;
    }

    public boolean cure(boolean causeEffects) {
        boolean wasVampire = this.isVampire;
        if (this.cure()) {
            if (causeEffects && wasVampire) {
                this.holder.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 240, 2));
                this.holder.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 2));
                this.holder.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1));
            }
            return true;
        }
        return false;
    }

    public void drink(LivingEntity target) {
        this.bloodData.drink(this.holder, target);
    }

    public void infect() {
        this.infect(12000);
    }

    public void infect(int duration) {
        this.holder.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 1));
        this.infectionTime = duration;
        this.startInfectionTime = duration;
        this.holder.syncData(VampireData.type());
    }

    public void infectImmediately() {
        this.infectionTime = 0;
        this.checkVampireStatus();
        this.holder.syncData(VampireData.type());
    }

    public void reduceInfection(int amount) {
        this.infectionTime += amount;
        if (this.infectionTime > this.startInfectionTime + 5000) {
            this.cure(false);
            this.holder.syncData(VampireData.type());
        }
    }

    public static AttachmentType<VampireData> type() {
        return SanguisDataAttachmentTypes.VAMPIRISM.get();
    }

    public boolean isInfected() {
        return this.infectionTime > 0;
    }

    public VampireBloodData getBloodData() {
        return this.bloodData;
    }

    protected void setHolder(IAttachmentHolder holder) {
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to set VampireData holder to non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)holder;
        this.holder = living;
        if (living.level().isClientSide() && this.bat == null) {
            this.bat = (Bat)EntityType.BAT.create(living.level());
        }
    }

    protected void setHolder(LivingEntity living) {
        this.holder = living;
    }

    public static VampireData copyDeathPersistent(VampireData oldData, IAttachmentHolder holder, HolderLookup.Provider provider) {
        VampireData newData = oldData.infectionTime != 0 ? new VampireData(oldData.isVampire, oldData.tier) : new VampireData(oldData.infectionTime, oldData.isVampire, oldData.tier);
        newData.setHolder(holder);
        return newData;
    }

    public static VampireData getInstance(IAttachmentHolder iAttachmentHolder) {
        if (!(iAttachmentHolder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to attach VampireData to non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)iAttachmentHolder;
        return new VampireData(living);
    }

    public VampireData update(IAttachmentHolder holder, RegistryFriendlyByteBuf buffer) {
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Trying to read VampireData for non-LivingEntity");
        }
        LivingEntity living = (LivingEntity)holder;
        this.infectionTime = buffer.readInt();
        this.startInfectionTime = buffer.readInt();
        this.isVampire = buffer.readBoolean();
        this.isBat = buffer.readBoolean();
        this.tier = buffer.readVarInt();
        this.bloodData.update(buffer);
        this.setHolder(living);
        return this;
    }

    public static class SyncHandler
    implements AttachmentSyncHandler<VampireData> {
        public void write(RegistryFriendlyByteBuf buf, VampireData attachment, boolean initialSync) {
            if (initialSync) {
                FULL_STREAM_CODEC.encode((Object)buf, (Object)attachment);
            } else {
                buf.writeInt(attachment.infectionTime);
                buf.writeInt(attachment.startInfectionTime);
                buf.writeBoolean(attachment.isVampire);
                buf.writeBoolean(attachment.isBat);
                buf.writeVarInt(attachment.tier);
                VampireBloodData.FULL_STREAM_CODEC.encode((Object)buf, (Object)attachment.bloodData);
            }
        }

        @Nullable
        public VampireData read(IAttachmentHolder holder, RegistryFriendlyByteBuf buf, @Nullable VampireData previousValue) {
            if (previousValue == null) {
                VampireData newData = (VampireData)FULL_STREAM_CODEC.decode((Object)buf);
                newData.setHolder(holder);
                return newData;
            }
            return previousValue.update(holder, buf);
        }
    }
}

