/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.block;

import com.feliscape.sanguis.content.block.BloodOrangeLeavesBlock;
import com.feliscape.sanguis.registry.SanguisBlocks;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BloodOrangeVineBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty HEAD = BooleanProperty.create((String)"head");
    private static final VoxelShape BODY_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape HEAD_SHAPE = Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BloodOrangeVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HEAD, (Comparable)Boolean.valueOf(true)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HEAD) != false ? HEAD_SHAPE : BODY_SHAPE;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        if (direction == Direction.DOWN) {
            return (BlockState)state.setValue((Property)HEAD, (Comparable)Boolean.valueOf(!this.isVineBlock(neighborState)));
        }
        return state;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos posAbove = pos.above();
        BlockState aboveState = level.getBlockState(posAbove);
        return this.canAttachTo(aboveState, level, pos);
    }

    private boolean canAttachTo(BlockState state, LevelReader level, BlockPos pos) {
        return state.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN, SupportType.CENTER) || state.is((Block)this);
    }

    private boolean isVineBlock(BlockState state) {
        return state.is((Block)this) || state.is(SanguisBlocks.BLOOD_ORANGE_LEAVES);
    }

    private BlockState getHeadGrowthState(RandomSource randomSource) {
        if (randomSource.nextInt(5) == 0) {
            return ((BloodOrangeLeavesBlock)((Object)SanguisBlocks.BLOOD_ORANGE_LEAVES.get())).defaultBlockState();
        }
        return (BlockState)((BloodOrangeVineBlock)((Object)SanguisBlocks.BLOOD_ORANGE_VINE.get())).defaultBlockState().setValue((Property)HEAD, (Comparable)Boolean.valueOf(true));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HEAD});
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)HEAD);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(5) == 0) {
            this.grow((Level)level, random, pos, state);
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        this.grow((Level)serverLevel, randomSource, blockPos, blockState);
    }

    private void grow(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        BlockPos headPos = (Boolean)state.getValue((Property)HEAD) != false ? pos : this.getHeadPos((BlockGetter)level, pos, this).orElse(pos);
        BlockState belowState = level.getBlockState(headPos.below());
        if (belowState.isAir()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HEAD, (Comparable)Boolean.valueOf(false)), 3);
            level.setBlockAndUpdate(headPos.below(), this.getHeadGrowthState(randomSource));
        }
    }

    private Optional<BlockPos> getHeadPos(BlockGetter level, BlockPos pos, Block block) {
        return BloodOrangeVineBlock.getTopConnectedBlock(level, pos, block, Direction.DOWN, blockState -> blockState.is((Block)this) && (Boolean)blockState.getValue((Property)HEAD) != false);
    }

    public static Optional<BlockPos> getTopConnectedBlock(BlockGetter getter, BlockPos pos, Block block, Direction direction, Predicate<BlockState> predicate) {
        BlockState blockstate;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        do {
            mutablePos.move(direction);
        } while (!predicate.test(blockstate = getter.getBlockState((BlockPos)mutablePos)) && blockstate.is(block));
        return predicate.test(blockstate) ? Optional.of(mutablePos) : Optional.empty();
    }
}

