/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.block;

import com.feliscape.sanguis.util.VampireUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoffinBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<CoffinBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DyeColor.CODEC.fieldOf("color").forGetter(CoffinBlock::getColor), (App)CoffinBlock.propertiesCodec()).apply((Applicative)inst, CoffinBlock::new));
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    private final DyeColor color;
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)4.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape SOUTH_SHAPE_SEALED = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape NORTH_SHAPE_SEALED = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)4.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape WEST_SHAPE_SEALED = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape EAST_SHAPE_SEALED = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)4.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});

    protected MapCodec<? extends CoffinBlock> codec() {
        return CODEC;
    }

    public CoffinBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public static Direction getBedOrientation(BlockGetter level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos);
        return blockstate.getBlock() instanceof CoffinBlock ? (Direction)blockstate.getValue((Property)FACING) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!VampireUtil.isVampire((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            state.setBedOccupied(level, pos, (LivingEntity)player, (Boolean)state.getValue((Property)OCCUPIED) == false);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (state.getValue(PART) != BedPart.HEAD && !(state = level.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!CoffinBlock.canSetSpawn(level)) {
            level.removeBlock(pos, false);
            BlockPos blockpos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
            if (level.getBlockState(blockpos).is((Block)this)) {
                level.removeBlock(blockpos, false);
            }
            Vec3 vec3 = pos.getCenter();
            level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.startSleepInBed(pos).ifLeft(problem -> {
            if (problem.getMessage() != null) {
                player.displayClientMessage(problem.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(Level level) {
        return level.dimensionType().bedWorks();
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).stopSleeping();
        return true;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
        level.setBlock(blockpos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == CoffinBlock.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return facingState.is((Block)this) && facingState.getValue(PART) != state.getValue(PART) ? (BlockState)state.setValue((Property)OCCUPIED, (Comparable)((Boolean)facingState.getValue((Property)OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!level.isClientSide && player.isCreative() && (bedpart = (BedPart)state.getValue(PART)) == BedPart.FOOT && (blockstate = level.getBlockState(blockpos = pos.relative(CoffinBlock.getNeighbourDirection(bedpart, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockstate.getValue(PART) == BedPart.HEAD) {
            level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        Level level = context.getLevel();
        return level.getBlockState(blockpos1).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(blockpos1) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = CoffinBlock.getConnectedDirection(state).getOpposite();
        boolean occupied = (Boolean)state.getValue((Property)OCCUPIED);
        switch (direction) {
            case NORTH: {
                return occupied ? NORTH_SHAPE_SEALED : NORTH_SHAPE;
            }
            case SOUTH: {
                return occupied ? SOUTH_SHAPE_SEALED : SOUTH_SHAPE;
            }
            case WEST: {
                return occupied ? WEST_SHAPE_SEALED : WEST_SHAPE;
            }
        }
        return occupied ? EAST_SHAPE_SEALED : EAST_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue(PART) == BedPart.HEAD ? direction.getOpposite() : direction;
    }

    protected long getSeed(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING), state.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)blockpos.getX(), (int)pos.getY(), (int)blockpos.getZ());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, OCCUPIED, FACING});
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return VampireUtil.isVampire((Entity)sleeper);
    }
}

