/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.block;

import com.feliscape.sanguis.content.block.entity.QuestBoardBlockEntity;
import com.feliscape.sanguis.registry.SanguisBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class QuestBoardBlock
extends BaseEntityBlock {
    private static final MapCodec<QuestBoardBlock> CODEC = QuestBoardBlock.simpleCodec(QuestBoardBlock::new);

    public QuestBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends QuestBoardBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof QuestBoardBlockEntity) {
            player.openMenu((MenuProvider)((QuestBoardBlockEntity)blockentity), pos);
        }
        return InteractionResult.CONSUME;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new QuestBoardBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return QuestBoardBlock.createTickerHelper(blockEntityType, SanguisBlockEntityTypes.QUEST_BOARD.get(), QuestBoardBlockEntity::tick);
    }
}

