/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.block.entity;

import com.feliscape.sanguis.content.menu.QuestBoardMenu;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.registry.SanguisBlockEntityTypes;
import com.feliscape.sanguis.util.QuestUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class QuestBoardBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ArrayList<HunterQuest> quests = new ArrayList();
    private int lastUpdate = -1;
    private boolean chosen = false;

    public QuestBoardBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public QuestBoardBlockEntity(BlockPos pos, BlockState blockState) {
        super(SanguisBlockEntityTypes.QUEST_BOARD.get(), pos, blockState);
    }

    public void onLoad() {
        super.onLoad();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag listTag = new ListTag();
        for (HunterQuest quest : this.quests) {
            listTag.add((Object)((Tag)HunterQuest.TYPED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)quest).getOrThrow()));
        }
        tag.put("quests", (Tag)listTag);
        tag.putInt("lastUpdate", this.lastUpdate);
        tag.putBoolean("hasChosen", this.chosen);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.quests.clear();
        if (tag.contains("quests")) {
            ListTag list = tag.getList("quests", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.quests.add((HunterQuest)((Pair)HunterQuest.TYPED_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)list.get(i)).getOrThrow()).getFirst());
            }
        }
        this.lastUpdate = tag.getInt("lastUpdate");
        this.chosen = tag.getBoolean("hasChosen");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, QuestBoardBlockEntity questBoard) {
        if (questBoard.quests.isEmpty()) {
            questBoard.update();
            return;
        }
        int day = Mth.floor((double)((double)level.getDayTime() / 24000.0));
        if (day > questBoard.lastUpdate) {
            questBoard.lastUpdate = day;
            questBoard.update();
        }
    }

    private void update() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.quests.clear();
        for (int i = 0; i < 3; ++i) {
            this.quests.add(QuestUtil.createRandom(serverLevel));
        }
        this.chosen = false;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public ArrayList<HunterQuest> getQuests() {
        return this.quests;
    }

    public boolean hasChosen() {
        return this.chosen;
    }

    @Nullable
    public HunterQuest choose(int index) {
        HunterQuest quest = this.getQuest(index);
        if (quest == null) {
            return null;
        }
        this.chosen = true;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        return quest;
    }

    @Nullable
    public HunterQuest getQuest(int index) {
        if (this.quests.isEmpty()) {
            this.createQuests();
        }
        if (index < 0 || index >= this.quests.size()) {
            return null;
        }
        return this.quests.get(index);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.sanguis.quest_board");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new QuestBoardMenu(containerId, playerInventory, this);
    }

    public void createQuests() {
        if (this.quests.isEmpty()) {
            this.update();
        }
    }
}

