/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.command;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.registry.custom.SanguisRegistries;
import com.feliscape.sanguis.util.HunterUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class QuestCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode literalcommandnode = dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sanguis").then(((LiteralArgumentBuilder)Commands.literal((String)"quest").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"addrandom").then(Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).executes(context -> QuestCommand.addRandom((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ResourceLocationArgument.getId((CommandContext)context, (String)"type"))))))));
    }

    private static int addRandom(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation id) {
        QuestType type = (QuestType)source.registryAccess().registryOrThrow(SanguisRegistries.Keys.QUEST_TYPES).get(id);
        if (type == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.sanguis.quest.addrandom.failure.invalid_type", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        for (ServerPlayer serverplayer : targets) {
            if (!HunterUtil.isHunter((Entity)serverplayer)) continue;
            ((HunterData)serverplayer.getData(HunterData.type())).addQuest((HunterQuest)type.factory().create(serverplayer.serverLevel()));
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.sanguis.quest.addrandom.success.single", (Object[])new Object[]{id.toString(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.sanguis.quest.addrandom.success.multiple", (Object[])new Object[]{id.toString(), targets.size()}), true);
        }
        return targets.size();
    }
}

