/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.component;

import com.feliscape.sanguis.Sanguis;
import com.feliscape.sanguis.content.quest.registry.QuestType;
import com.feliscape.sanguis.registry.custom.SanguisRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;

public class GeneratedName {
    public static final Codec<GeneratedName> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SanguisRegistries.QUEST_TYPES.byNameCodec().fieldOf("quest_type").forGetter(n -> n.questType), (App)Codec.STRING.optionalFieldOf("generated_string").forGetter(n -> n.generatedString)).apply((Applicative)inst, GeneratedName::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GeneratedName> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(SanguisRegistries.Keys.QUEST_TYPES), n -> n.questType, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), n -> n.generatedString, GeneratedName::new);
    private QuestType<?> questType;
    private Optional<String> generatedString = Optional.empty();
    public boolean hasBeenGenerated;
    @Nullable
    private Language decomposedWith;

    public GeneratedName(QuestType<?> questType) {
        this.questType = questType;
    }

    public GeneratedName(QuestType<?> questType, Optional<String> generatedString) {
        this.questType = questType;
        this.generatedString = generatedString;
        this.hasBeenGenerated = true;
    }

    private void decompose() {
        Language language = Language.getInstance();
        if (language != this.decomposedWith) {
            this.decomposedWith = language;
            if (this.hasBeenGenerated) {
                this.hasBeenGenerated = false;
                return;
            }
            this.generatedString = Optional.of(Sanguis.NAME_GENERATOR.generateName(this.questType, RandomSource.create().nextLong()));
        }
    }

    public String getString() {
        this.decompose();
        return this.generatedString.isPresent() ? this.generatedString.get() : "";
    }
}

