/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.entity.ai;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class RunAwayFromBlockGoal
extends Goal {
    protected final PathfinderMob mob;
    private final Predicate<BlockState> predicate;
    private final double speedModifier;
    private int horizontalRange = 8;
    private int verticalRange = 4;
    protected Path path;

    public RunAwayFromBlockGoal(PathfinderMob mob, Predicate<BlockState> predicate, double speedModifier) {
        this.mob = mob;
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    public RunAwayFromBlockGoal(PathfinderMob mob, Block block, double speedModifier) {
        this.mob = mob;
        this.predicate = state -> state.is(block);
        this.speedModifier = speedModifier;
    }

    public RunAwayFromBlockGoal(PathfinderMob mob, TagKey<Block> block, double speedModifier) {
        this.mob = mob;
        this.predicate = state -> state.is(block);
        this.speedModifier = speedModifier;
    }

    public RunAwayFromBlockGoal(PathfinderMob mob, Predicate<BlockState> predicate, int horizontalRange, int verticalRange, double speedModifier) {
        this.mob = mob;
        this.predicate = predicate;
        this.speedModifier = speedModifier;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
    }

    public RunAwayFromBlockGoal(PathfinderMob mob, Block block, int horizontalRange, int verticalRange, double speedModifier) {
        this.mob = mob;
        this.predicate = state -> state.is(block);
        this.speedModifier = speedModifier;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
    }

    public RunAwayFromBlockGoal(PathfinderMob mob, TagKey<Block> block, int horizontalRange, int verticalRange, double speedModifier) {
        this.mob = mob;
        this.predicate = state -> state.is(block);
        this.speedModifier = speedModifier;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
    }

    public Predicate<BlockState> block() {
        return this.predicate;
    }

    public boolean canUse() {
        Optional<BlockPos> nearestRepellentOptional = this.nearestBlockToAvoid(this.horizontalRange, this.verticalRange);
        if (nearestRepellentOptional.isEmpty()) {
            return false;
        }
        BlockPos nearestRepellent = nearestRepellentOptional.get();
        Vec3 repellentCenter = nearestRepellent.getBottomCenter();
        Vec3 pos = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)12, (int)7, (Vec3)repellentCenter);
        if (pos == null) {
            return false;
        }
        if (repellentCenter.distanceToSqr(pos) < pos.distanceToSqr(this.mob.position())) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath(pos.x, pos.y, pos.z, 0);
        return this.path != null;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, 1.2);
    }

    public void stop() {
        this.path = null;
    }

    private Optional<BlockPos> nearestBlockToAvoid(int horizontalRange, int verticalRange) {
        return BlockPos.findClosestMatch((BlockPos)this.mob.blockPosition(), (int)horizontalRange, (int)verticalRange, pos -> this.predicate.test(this.mob.level().getBlockState(pos)));
    }
}

