/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.event;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.attachment.HunterQuestData;
import com.feliscape.sanguis.content.entity.living.VampireEntity;
import com.feliscape.sanguis.content.entity.living.VampireHunter;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.content.quest.KillMobsQuest;
import com.feliscape.sanguis.registry.SanguisEntityTypes;
import com.feliscape.sanguis.util.HunterUtil;
import com.feliscape.sanguis.util.VampireUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="sanguis")
public class GeneralEvents {
    @SubscribeEvent
    public static void entityKilled(LivingDeathEvent event) {
        Player player;
        Entity cause = event.getSource().getEntity();
        if (cause instanceof Player && HunterUtil.isHunter((Entity)(player = (Player)cause))) {
            HunterQuestData data = ((HunterData)player.getData(HunterData.type())).getQuests();
            for (HunterQuest quest : data.getActiveQuests()) {
                if (!(quest instanceof KillMobsQuest)) continue;
                KillMobsQuest killMobsQuest = (KillMobsQuest)quest;
                killMobsQuest.recordKill(event.getEntity().getType());
            }
        }
    }

    @SubscribeEvent
    public static void createEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SanguisEntityTypes.VAMPIRE.get(), VampireEntity.createAttributes());
        event.put((EntityType)SanguisEntityTypes.VAMPIRE_HUNTER.get(), VampireHunter.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SanguisEntityTypes.VAMPIRE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireEntity::checkVampireSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)SanguisEntityTypes.VAMPIRE_HUNTER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!entity.isAlive()) {
            return;
        }
        if (entity instanceof WanderingTrader) {
            WanderingTrader mob = (WanderingTrader)entity;
            mob.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)mob, LivingEntity.class, 8.0f, 0.5, 0.5, VampireUtil::isVampire));
        } else if (entity instanceof IronGolem) {
            IronGolem mob = (IronGolem)entity;
            mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, LivingEntity.class, 5, false, false, VampireUtil::isVampire));
        }
    }
}

