/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.event;

import com.feliscape.sanguis.content.attachment.DataAttachment;
import com.feliscape.sanguis.content.attachment.EntityBloodData;
import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.content.block.CoffinBlock;
import com.feliscape.sanguis.registry.SanguisTags;
import com.feliscape.sanguis.util.VampireUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="sanguis")
public class VampirismHandler {
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            DataAttachment data;
            LivingEntity living = (LivingEntity)entity;
            if (living.hasData(VampireData.type())) {
                data = (VampireData)living.getData(VampireData.type());
                ((VampireData)data).tick();
            }
            if (living.hasData(EntityBloodData.type())) {
                data = (EntityBloodData)living.getData(EntityBloodData.type());
                ((EntityBloodData)data).tick();
            }
            if (living.hasData(HunterData.type())) {
                data = (HunterData)living.getData(HunterData.type());
                ((HunterData)data).tick();
            }
        }
    }

    @SubscribeEvent
    public static void entityUseItem(LivingEntityUseItemEvent.Start event) {
        LivingEntity entity = event.getEntity();
        if (VampireUtil.isVampire((Entity)entity) && event.getItem().getFoodProperties(entity) != null && !event.getItem().is(SanguisTags.Items.VAMPIRE_EDIBLE)) {
            event.setCanceled(true);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)"sanguis.cant_eat_message"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingBreathe(LivingBreatheEvent event) {
        if (!VampireUtil.isVampire((Entity)event.getEntity())) {
            return;
        }
        event.setCanBreathe(true);
    }

    @SubscribeEvent
    public static void canContinueSleeping(CanContinueSleepingEvent event) {
        LivingEntity entity = event.getEntity();
        if (!VampireUtil.isVampire((Entity)entity)) {
            return;
        }
        boolean canSleepAsVampire = VampireUtil.isDay(entity.level());
        if (event.mayContinueSleeping() && !canSleepAsVampire) {
            event.setContinueSleeping(false);
        } else if (!event.mayContinueSleeping() && canSleepAsVampire && event.getProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
            event.setContinueSleeping(true);
        }
    }

    @SubscribeEvent
    public static void canPlayerSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        if (!VampireUtil.isVampire((Entity)player)) {
            return;
        }
        Player.BedSleepingProblem problem = event.getVanillaProblem();
        boolean canSleepAsVampire = VampireUtil.isDay(player.level());
        if (canSleepAsVampire && problem == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && event.getProblem() == problem) {
            event.setProblem(null);
        } else if (!canSleepAsVampire) {
            event.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
    }

    @SubscribeEvent
    public static void overrideSleepTime(SleepFinishedTimeEvent event) {
        LevelAccessor level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.players();
            boolean daySleeping = false;
            for (Player player : players) {
                Block block;
                Optional sleepingPos = player.getSleepingPos();
                if (sleepingPos.isPresent() && player.isSleepingLongEnough() && (block = level.getBlockState((BlockPos)sleepingPos.get()).getBlock()) instanceof CoffinBlock) {
                    daySleeping = true;
                }
                if (!daySleeping) continue;
                break;
            }
            if (daySleeping) {
                long i = serverLevel.getDayTime() + 24000L;
                long result = i - i % 24000L - 11001L;
                event.setTimeAddition(result);
            }
        }
    }
}

