/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.item;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.registry.SanguisItems;
import com.feliscape.sanguis.registry.SanguisSoundEvents;
import com.feliscape.sanguis.util.HunterUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AcidInjectionItem
extends Item {
    public AcidInjectionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown() && HunterUtil.isHunter((Entity)player)) {
            ((HunterData)player.getData(HunterData.type())).removeGarlic();
            player.addEffect(new MobEffectInstance(MobEffects.WITHER, 400, 2));
            ItemStack returnStack = SanguisItems.SYRINGE.toStack();
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SanguisSoundEvents.INJECT.get(), player.getSoundSource(), 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
            return InteractionResultHolder.sidedSuccess((Object)(player.hasInfiniteMaterials() ? itemStack : returnStack), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip")).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".warning")).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
    }
}

