/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.item;

import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.registry.SanguisSoundEvents;
import com.feliscape.sanguis.util.VampireUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BlackenedCoinItem
extends Item {
    public BlackenedCoinItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (VampireUtil.isVampire((Entity)player)) {
            VampireData data = (VampireData)player.getData(VampireData.type());
            if (!data.canUpgrade()) {
                return super.use(level, player, usedHand);
            }
            itemStack.consume(1, (LivingEntity)player);
            data.upgradeTier();
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SanguisSoundEvents.BLACKENED_COIN_USE.get(), player.getSoundSource());
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }
}

