/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.item;

import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.registry.SanguisDataComponents;
import com.feliscape.sanguis.registry.SanguisItems;
import com.feliscape.sanguis.util.VampireUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class BloodBottleItem
extends Item {
    public BloodBottleItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getWithFill(int fill) {
        ItemStack itemStack = SanguisItems.BLOOD_BOTTLE.toStack();
        itemStack.set(SanguisDataComponents.BLOOD, (Object)fill);
        return itemStack;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        if (entityLiving.hasData(VampireData.type()) && VampireUtil.isVampire((Entity)entityLiving)) {
            VampireData data = (VampireData)entityLiving.getData(VampireData.type());
            data.getBloodData().drink(entityLiving, 1, 0.6f);
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            int blood = (Integer)stack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
            if (blood > 0) {
                stack.set(SanguisDataComponents.BLOOD, (Object)(blood - 1));
            }
            return stack;
        }
        entityLiving.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if ((Integer)itemStack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0) <= 0) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int blood = (Integer)stack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
        int maxBlood = (Integer)stack.getOrDefault(SanguisDataComponents.MAX_BLOOD, (Object)0);
        tooltipComponents.add((Component)Component.literal((String)(blood + "/" + maxBlood)).withStyle(ChatFormatting.GRAY));
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        int blood = (Integer)itemStack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0);
        if (blood <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = itemStack.copy();
        copy.set(SanguisDataComponents.BLOOD, (Object)(blood - 1));
        return copy;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return (Integer)stack.getOrDefault(SanguisDataComponents.BLOOD, (Object)0) > 0;
    }
}

