/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.item;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.attachment.VampireData;
import com.feliscape.sanguis.registry.SanguisItems;
import com.feliscape.sanguis.registry.SanguisSoundEvents;
import com.feliscape.sanguis.util.HunterUtil;
import com.feliscape.sanguis.util.VampireUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GarlicInjectionItem
extends Item {
    public GarlicInjectionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            ItemStack returnStack = SanguisItems.SYRINGE.toStack();
            if (HunterUtil.canInject((Entity)player)) {
                ((HunterData)player.getData(HunterData.type())).injectGarlic();
                if (VampireUtil.isInfected((Entity)player)) {
                    ((VampireData)player.getData(VampireData.type())).cure(false);
                }
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 0));
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SanguisSoundEvents.INJECT.get(), player.getSoundSource(), 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
                return InteractionResultHolder.sidedSuccess((Object)(player.hasInfiniteMaterials() ? itemStack : returnStack), (boolean)level.isClientSide());
            }
            if (VampireUtil.isVampire((Entity)player)) {
                ((VampireData)player.getData(VampireData.type())).cure(true);
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SanguisSoundEvents.INJECT.get(), player.getSoundSource(), 1.0f, level.random.nextFloat() * 0.2f + 0.9f);
                return InteractionResultHolder.sidedSuccess((Object)(player.hasInfiniteMaterials() ? itemStack : returnStack), (boolean)level.isClientSide());
            }
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip")).withStyle(ChatFormatting.GRAY));
    }
}

