/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.item;

import com.feliscape.sanguis.content.attachment.VampireData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class VampireCureItem
extends Item {
    public VampireCureItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        VampireData data;
        Player player;
        Player player2 = player = entityLiving instanceof Player ? (Player)entityLiving : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, stack);
        }
        if (entityLiving.hasData(VampireData.type()) && ((data = (VampireData)entityLiving.getData(VampireData.type())).isInfected() || data.isVampire())) {
            data.cure(true);
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
        }
        if (player == null || !player.hasInfiniteMaterials()) {
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            if (player != null) {
                player.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
        }
        entityLiving.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip")).withStyle(ChatFormatting.GRAY));
    }
}

