/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.menu;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.attachment.HunterQuestData;
import com.feliscape.sanguis.registry.SanguisMenuTypes;
import com.feliscape.sanguis.util.HunterUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ActiveQuestsMenu
extends AbstractContainerMenu {
    @Nullable
    public final HunterQuestData data;
    private final Player player;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    public ActiveQuestsMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, inventory.player);
    }

    public ActiveQuestsMenu(int id, Inventory inventory, Player player) {
        super(SanguisMenuTypes.ACTIVE_QUESTS.get(), id);
        this.player = player;
        this.data = HunterUtil.isHunter((Entity)player) ? ((HunterData)player.getData(HunterData.type())).getQuests() : null;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    public boolean stillValid(Player player) {
        return HunterUtil.isHunter((Entity)player);
    }

    public HunterQuestData getData() {
        return ((HunterData)this.player.getData(HunterData.type())).getQuests();
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 130 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 188));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }
}

