/*
 * Decompiled with CFR 0.152.
 */
package com.feliscape.sanguis.content.menu;

import com.feliscape.sanguis.content.attachment.HunterData;
import com.feliscape.sanguis.content.block.entity.QuestBoardBlockEntity;
import com.feliscape.sanguis.content.quest.HunterQuest;
import com.feliscape.sanguis.registry.SanguisBlocks;
import com.feliscape.sanguis.registry.SanguisMenuTypes;
import com.feliscape.sanguis.util.HunterUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class QuestBoardMenu
extends AbstractContainerMenu {
    public final QuestBoardBlockEntity blockEntity;
    private final Level level;

    public QuestBoardMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, QuestBoardMenu.getTileEntity(inv, extraData));
    }

    public QuestBoardMenu(int containerId, Inventory inv, BlockEntity entity) {
        super(SanguisMenuTypes.QUEST_BOARD.get(), containerId);
        this.blockEntity = (QuestBoardBlockEntity)entity;
        this.blockEntity.createQuests();
        this.level = inv.player.level();
    }

    private static QuestBoardBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof QuestBoardBlockEntity) {
            return (QuestBoardBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public void chooseQuest(int index, Player player) {
        if (!HunterUtil.isHunter((Entity)player)) {
            return;
        }
        HunterQuest quest = this.blockEntity.choose(index);
        if (quest != null) {
            HunterData data = (HunterData)player.getData(HunterData.type());
            data.addQuest(quest);
        }
    }

    public boolean stillValid(Player player) {
        return QuestBoardMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)SanguisBlocks.QUEST_BOARD.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

